/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.transform.filter.request.MaskOperation;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.restli.internal.common.IllegalMaskException;
import java.util.ArrayDeque;
import java.util.Map;

public class URIMaskUtil {
    public static String encodeMaskForURI(MaskTree maskTree) {
        return URIMaskUtil.encodeMaskForURIImpl(maskTree.getDataMap(), false);
    }

    public static String encodeMaskForURI(DataMap simplifiedMask) {
        return URIMaskUtil.encodeMaskForURIImpl(simplifiedMask, false);
    }

    private static String encodeMaskForURIImpl(DataMap simplifiedMask, boolean parenthesize) {
        StringBuilder result = new StringBuilder();
        if (parenthesize) {
            result.append(":(");
        }
        boolean delimit = false;
        for (Map.Entry entry : simplifiedMask.entrySet()) {
            if (delimit) {
                result.append(",");
            }
            delimit = true;
            if (entry.getValue().equals(MaskOperation.POSITIVE_MASK_OP.getRepresentation())) {
                result.append((String)entry.getKey());
                continue;
            }
            if (entry.getValue().equals(MaskOperation.NEGATIVE_MASK_OP.getRepresentation())) {
                result.append('-');
                result.append((String)entry.getKey());
                continue;
            }
            result.append((String)entry.getKey());
            result.append(URIMaskUtil.encodeMaskForURIImpl((DataMap)entry.getValue(), true));
        }
        if (parenthesize) {
            result.append(")");
        }
        return result.toString();
    }

    public static MaskTree decodeMaskUriFormat(StringBuilder toparse) throws IllegalMaskException {
        ParseState state = ParseState.PARSE_FIELDS;
        DataMap result = new DataMap();
        ArrayDeque<DataMap> stack = new ArrayDeque<DataMap>();
        stack.addLast(result);
        while (toparse.length() > 0) {
            switch (state) {
                case TRAVERSE: {
                    if (toparse.indexOf(",") != 0) {
                        throw new IllegalStateException("Internal Error parsing mask: unexpected parse buffer '" + toparse + "' while traversing");
                    }
                    toparse.delete(0, 1);
                    state = ParseState.PARSE_FIELDS;
                    break;
                }
                case DESCEND: {
                    if (toparse.indexOf(":(") != 0) {
                        throw new IllegalStateException("Internal Error parsing mask: unexpected parse buffer '" + toparse + "' while descending");
                    }
                    toparse.delete(0, 2);
                    state = ParseState.PARSE_FIELDS;
                    break;
                }
                case PARSE_FIELDS: {
                    Integer maskValue = null;
                    if (toparse.charAt(0) == '-') {
                        maskValue = MaskOperation.NEGATIVE_MASK_OP.getRepresentation();
                        toparse.delete(0, 1);
                    } else {
                        maskValue = MaskOperation.POSITIVE_MASK_OP.getRepresentation();
                    }
                    int nextToken = -1;
                    StringBuilder field = new StringBuilder();
                    for (int ii = 0; ii < toparse.length(); ++ii) {
                        char c = toparse.charAt(ii);
                        switch (c) {
                            case ',': {
                                state = ParseState.TRAVERSE;
                                nextToken = ii;
                                break;
                            }
                            case ':': {
                                if (toparse.charAt(ii + 1) != '(') {
                                    throw new IllegalMaskException("Malformed mask syntax: expected '(' token");
                                }
                                state = ParseState.DESCEND;
                                nextToken = ii;
                                break;
                            }
                            case ')': {
                                state = ParseState.ASCEND;
                                nextToken = ii;
                                break;
                            }
                            default: {
                                field.append(c);
                            }
                        }
                        if (nextToken != -1) break;
                    }
                    if (toparse.length() != field.length()) {
                        if (nextToken == -1) {
                            throw new IllegalMaskException("Malformed mask syntax: expected closing token");
                        }
                        toparse.delete(0, nextToken);
                    } else {
                        toparse.delete(0, toparse.length());
                    }
                    if (state == ParseState.DESCEND) {
                        if (field.length() == 0) {
                            throw new IllegalMaskException("Malformed mask syntax: empty parent field name");
                        }
                        DataMap subTree = new DataMap();
                        ((DataMap)stack.peekLast()).put((Object)field.toString().trim(), (Object)subTree);
                        stack.addLast(subTree);
                        break;
                    }
                    if (field.length() == 0) break;
                    ((DataMap)stack.peekLast()).put((Object)field.toString().trim(), (Object)maskValue);
                    break;
                }
                case ASCEND: {
                    if (toparse.indexOf(")") != 0) {
                        throw new IllegalStateException("Internal Error parsing mask: unexpected parse buffer '" + toparse + "' while ascending");
                    }
                    if (stack.isEmpty()) {
                        throw new IllegalMaskException("Malformed mask syntax: unexpected ')' token");
                    }
                    toparse.delete(0, 1);
                    stack.removeLast();
                    state = ParseState.PARSE_FIELDS;
                }
            }
        }
        if (stack.size() != 1) {
            throw new IllegalMaskException("Malformed mask syntax: unmatched nesting");
        }
        result = (DataMap)stack.removeLast();
        return new MaskTree(result);
    }

    private static enum ParseState {
        DESCEND,
        PARSE_FIELDS,
        ASCEND,
        TRAVERSE;

    }
}

