/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;

public abstract class AvroToJsonStringConverterBase<T>
extends Converter<Schema, String, GenericRecord, T> {
    private Schema schema;
    private final ThreadLocal<Serializer> serializer = new ThreadLocal<Serializer>(){

        @Override
        protected Serializer initialValue() {
            return new Serializer(AvroToJsonStringConverterBase.this.schema);
        }
    };

    public String convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        this.schema = inputSchema;
        return this.schema.toString();
    }

    public Iterable<T> convertRecord(String outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            byte[] utf8Bytes = this.serializer.get().serialize(inputRecord);
            return Collections.singleton(this.processUtf8Bytes(utf8Bytes));
        }
        catch (IOException ioe) {
            throw new DataConversionException((Throwable)ioe);
        }
    }

    protected abstract T processUtf8Bytes(byte[] var1);

    private static class Serializer {
        private final Encoder encoder;
        private final GenericDatumWriter<GenericRecord> writer;
        private final ByteArrayOutputStream outputStream;

        public Serializer(Schema schema) {
            try {
                this.writer = new GenericDatumWriter(schema);
                this.outputStream = new ByteArrayOutputStream();
                this.encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)this.outputStream);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not initialize avro json encoder.");
            }
        }

        public byte[] serialize(GenericRecord record) throws IOException {
            this.outputStream.reset();
            this.writer.write((Object)record, this.encoder);
            this.encoder.flush();
            return this.outputStream.toByteArray();
        }
    }
}

