/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.serialize;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistryFactory;
import org.apache.gobblin.kafka.schemareg.SchemaRegistryException;
import org.apache.gobblin.kafka.serialize.MD5Digest;
import org.apache.gobblin.kafka.serialize.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiAvroDeserializerBase {
    private static final Logger log = LoggerFactory.getLogger(LiAvroDeserializerBase.class);
    private KafkaSchemaRegistry<MD5Digest, Schema> _schemaRegistry;
    private GenericDatumReader<GenericData.Record> _datumReader;

    public LiAvroDeserializerBase() {
    }

    public LiAvroDeserializerBase(KafkaSchemaRegistry<MD5Digest, Schema> schemaRegistry) {
        this._schemaRegistry = schemaRegistry;
        this._datumReader = new GenericDatumReader();
        Preconditions.checkState((this._schemaRegistry != null ? 1 : 0) != 0, (Object)"Schema Registry is not initialized");
        Preconditions.checkState((this._datumReader != null ? 1 : 0) != 0, (Object)"Datum Reader is not initialized");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        Preconditions.checkArgument((!isKey ? 1 : 0) != 0, (Object)"LiAvroDeserializer only works for value fields");
        this._datumReader = new GenericDatumReader();
        Properties props = new Properties();
        for (Map.Entry<String, ?> entry : configs.entrySet()) {
            String value = String.valueOf(entry.getValue());
            props.setProperty(entry.getKey(), value);
        }
        this._schemaRegistry = KafkaSchemaRegistryFactory.getSchemaRegistry(props);
    }

    public GenericRecord deserialize(String topic, byte[] data, Schema outputSchema) throws SerializationException {
        try {
            if (data[0] != 0) {
                throw new SerializationException(String.format("Unknown magic byte for topic: %s ", topic));
            }
            MD5Digest schemaId = MD5Digest.fromBytes(data, 1);
            Schema schema = this._schemaRegistry.getById(schemaId);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, 17, data.length - 16 - 1, null);
            this._datumReader.setExpected(outputSchema);
            this._datumReader.setSchema(schema);
            try {
                GenericRecord record = (GenericRecord)this._datumReader.read(null, (Decoder)decoder);
                return record;
            }
            catch (IOException e) {
                log.error(String.format("Error during decoding record for topic %s: ", topic));
                throw e;
            }
        }
        catch (IOException | SchemaRegistryException e) {
            throw new SerializationException("Error during Deserialization", e);
        }
    }

    public GenericRecord deserialize(String topic, byte[] data) throws SerializationException {
        return this.deserialize(topic, data, null);
    }

    public void close() {
    }
}

