/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.serialize;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class MD5Digest {
    public static final int MD5_BYTES_LENGTH = 16;
    private final byte[] bytes;
    private final String md5String;

    private MD5Digest(String md5String, byte[] md5bytes) {
        this.bytes = md5bytes;
        this.md5String = md5String;
    }

    public String asString() {
        return this.md5String;
    }

    public byte[] asBytes() {
        return this.bytes;
    }

    public static MD5Digest fromString(String md5String) {
        try {
            byte[] bytes = Hex.decodeHex((char[])md5String.toCharArray());
            return new MD5Digest(md5String, bytes);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Unable to convert md5string", e);
        }
    }

    public static MD5Digest fromBytes(byte[] md5Bytes) {
        Preconditions.checkArgument((md5Bytes.length == 16 ? 1 : 0) != 0, (Object)("md5 bytes must be 16 bytes in length, found " + md5Bytes.length + " bytes."));
        String md5String = Hex.encodeHexString((byte[])md5Bytes);
        return new MD5Digest(md5String, md5Bytes);
    }

    public static MD5Digest fromBytes(byte[] md5Bytes, int offset) {
        byte[] md5BytesCopy = Arrays.copyOfRange(md5Bytes, offset, offset + 16);
        String md5String = Hex.encodeHexString((byte[])md5BytesCopy);
        return new MD5Digest(md5String, md5BytesCopy);
    }

    public int hashCode() {
        return this.md5String.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MD5Digest)) {
            return false;
        }
        MD5Digest other = (MD5Digest)obj;
        if (this.md5String == null) {
            return other.md5String == null;
        }
        return this.md5String.equals(other.md5String);
    }
}

