/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

public class KafkaRecord
implements Comparable<KafkaRecord> {
    private final Long offset;
    private final String key;
    private final String payload;

    public KafkaRecord(long offset, String key, String payload) {
        this.offset = offset;
        this.key = key;
        this.payload = payload;
    }

    public String toString() {
        return "KafkaRecord [offset=" + this.offset + ", key=" + this.key + ", payload=" + this.payload + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaRecord other = (KafkaRecord)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (!this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.payload == null ? other.payload != null : !this.payload.equals(other.payload));
    }

    @Override
    public int compareTo(KafkaRecord o) {
        return this.offset.compareTo(o.offset);
    }

    public Long getOffset() {
        return this.offset;
    }

    public String getKey() {
        return this.key;
    }

    public String getPayload() {
        return this.payload;
    }
}

