/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.EventSubmitter;

public class MultiTimingEvent
implements Closeable {
    public static final String MULTI_TIMING_EVENT = "multiTimingEvent";
    private final String name;
    private final EventSubmitter submitter;
    private final List<Stage> timings;
    private boolean submitted;
    private final boolean reportAsMetrics;
    private String currentStage;
    private long currentStageStart;

    public MultiTimingEvent(EventSubmitter submitter, String name, boolean reportAsMetrics) {
        this.name = name;
        this.submitter = submitter;
        this.timings = Lists.newArrayList();
        this.submitted = false;
        this.reportAsMetrics = reportAsMetrics;
    }

    public void nextStage(String name) throws IOException {
        this.endStage();
        this.currentStage = name;
        this.currentStageStart = System.currentTimeMillis();
    }

    public void endStage() {
        if (this.currentStage != null) {
            long time = System.currentTimeMillis() - this.currentStageStart;
            this.timings.add(new Stage(this.currentStage, time));
            if (this.reportAsMetrics && this.submitter.getMetricContext().isPresent()) {
                String timerName = this.submitter.getNamespace() + "." + this.name + "." + this.currentStage;
                ((MetricContext)this.submitter.getMetricContext().get()).timer(timerName).update(time, TimeUnit.MILLISECONDS);
            }
        }
        this.currentStage = null;
    }

    public void submit() throws IOException {
        this.submit(Maps.newHashMap());
    }

    public void submit(Map<String, String> additionalMetadata) throws IOException {
        if (this.submitted) {
            throw new IOException("MultiTimingEvent has already been submitted.");
        }
        this.submitted = true;
        this.endStage();
        HashMap finalMetadata = Maps.newHashMap();
        finalMetadata.putAll(additionalMetadata);
        finalMetadata.put("eventType", MULTI_TIMING_EVENT);
        for (Stage timing : this.timings) {
            finalMetadata.put(timing.getName(), Long.toString(timing.getDuration()));
        }
        this.submitter.submit(this.name, finalMetadata);
    }

    @Override
    public void close() throws IOException {
        this.submit();
    }

    private static class Stage {
        private final String name;
        private final long duration;

        @ConstructorProperties(value={"name", "duration"})
        public Stage(String name, long duration) {
            this.name = name;
            this.duration = duration;
        }

        public String getName() {
            return this.name;
        }

        public long getDuration() {
            return this.duration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Stage)) {
                return false;
            }
            Stage other = (Stage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getDuration() == other.getDuration();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Stage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            return result;
        }

        public String toString() {
            return "MultiTimingEvent.Stage(name=" + this.getName() + ", duration=" + this.getDuration() + ")";
        }
    }
}

