/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event.lineage;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gobblin.broker.EmptyKey;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.DatasetResolver;
import org.apache.gobblin.dataset.DatasetResolverFactory;
import org.apache.gobblin.dataset.NoopDatasetResolver;
import org.apache.gobblin.metrics.broker.LineageInfoFactory;
import org.apache.gobblin.metrics.event.lineage.LineageEventBuilder;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LineageInfo {
    private static final Logger log = LoggerFactory.getLogger(LineageInfo.class);
    private static final String DATASET_RESOLVER_FACTORY = "datasetResolverFactory";
    private static final String DATASET_RESOLVER_CONFIG_NAMESPACE = "datasetResolver";
    private static final String BRANCH = "branch";
    private static final Gson GSON = new Gson();
    private static final String NAME_KEY = "name";
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"datasetResolverFactory", (Object)"NOOP").build());
    private final DatasetResolver resolver;

    public LineageInfo(Config config) {
        this.resolver = LineageInfo.getResolver(config.withFallback((ConfigMergeable)FALLBACK));
    }

    public void setSource(DatasetDescriptor source, State state) {
        DatasetDescriptor descriptor = this.resolver.resolve(source, state);
        if (descriptor == null) {
            return;
        }
        state.setProp(LineageInfo.getKey(NAME_KEY), (Object)descriptor.getName());
        state.setProp(LineageInfo.getKey("source"), (Object)GSON.toJson((Object)descriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDestination(DatasetDescriptor destination, int branchId, State state) {
        if (!LineageInfo.hasLineageInfo(state)) {
            log.warn("State has no lineage info but branch " + branchId + " puts a destination: " + GSON.toJson((Object)destination));
            return;
        }
        log.debug(String.format("Put destination %s for branch %d", GSON.toJson((Object)destination), branchId));
        String string = state.getProp(LineageInfo.getKey(NAME_KEY));
        synchronized (string) {
            DatasetDescriptor descriptor = this.resolver.resolve(destination, state);
            if (descriptor == null) {
                return;
            }
            state.setProp(LineageInfo.getKey(BRANCH, branchId, "destination"), (Object)GSON.toJson((Object)descriptor));
        }
    }

    public static Collection<LineageEventBuilder> load(Collection<? extends State> states) {
        Preconditions.checkArgument((states != null && !states.isEmpty() ? 1 : 0) != 0);
        HashSet allEvents = Sets.newHashSet();
        for (State state : states) {
            Map<String, LineageEventBuilder> branchedEvents = LineageInfo.load(state);
            allEvents.addAll(branchedEvents.values());
        }
        return allEvents;
    }

    static Map<String, LineageEventBuilder> load(State state) {
        String name = state.getProp(LineageInfo.getKey(NAME_KEY));
        DatasetDescriptor source = (DatasetDescriptor)GSON.fromJson(state.getProp(LineageInfo.getKey("source")), DatasetDescriptor.class);
        String branchedPrefix = LineageInfo.getKey(BRANCH, "");
        HashMap events = Maps.newHashMap();
        block6: for (Map.Entry<Object, Object> entry : state.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(branchedPrefix)) continue;
            String[] parts = key.substring(branchedPrefix.length()).split("\\.");
            assert (parts.length == 2);
            String branchId = parts[0];
            LineageEventBuilder event = (LineageEventBuilder)events.get(branchId);
            if (event == null) {
                event = new LineageEventBuilder(name);
                event.setSource(new DatasetDescriptor(source));
                events.put(parts[0], event);
            }
            switch (parts[1]) {
                case "destination": {
                    DatasetDescriptor destination = (DatasetDescriptor)GSON.fromJson(entry.getValue().toString(), DatasetDescriptor.class);
                    event.setDestination(destination);
                    continue block6;
                }
            }
            throw new RuntimeException("Unsupported lineage key: " + key);
        }
        return events;
    }

    public static void purgeLineageInfo(State state) {
        state.removePropsWithPrefix(LineageEventBuilder.LIENAGE_EVENT_NAMESPACE);
    }

    public static boolean hasLineageInfo(State state) {
        return state.contains(LineageInfo.getKey(NAME_KEY));
    }

    public static String getFullEventName(State state) {
        return Joiner.on((char)'.').join((Object)LineageEventBuilder.LIENAGE_EVENT_NAMESPACE, (Object)state.getProp(LineageInfo.getKey(NAME_KEY)), new Object[0]);
    }

    public static Optional<LineageInfo> getLineageInfo(@Nullable SharedResourcesBroker<GobblinScopeTypes> broker) {
        if (broker == null) {
            log.warn("Null broker. Will not track data lineage");
            return Optional.absent();
        }
        try {
            LineageInfo lineageInfo = (LineageInfo)broker.getSharedResource((SharedResourceFactory)new LineageInfoFactory(), (SharedResourceKey)EmptyKey.INSTANCE);
            return Optional.of((Object)lineageInfo);
        }
        catch (NotConfiguredException e) {
            log.warn("Fail to get LineageInfo instance from broker. Will not track data lineage", (Throwable)e);
            return Optional.absent();
        }
    }

    public static DatasetResolver getResolver(Config config) {
        String resolverFactory = config.getString(DATASET_RESOLVER_FACTORY);
        if (resolverFactory.equals("NOOP")) {
            return NoopDatasetResolver.INSTANCE;
        }
        NoopDatasetResolver resolver = NoopDatasetResolver.INSTANCE;
        try {
            DatasetResolverFactory factory = (DatasetResolverFactory)Class.forName(resolverFactory).newInstance();
            resolver = factory.createResolver(ConfigUtils.getConfigOrEmpty((Config)config, (String)DATASET_RESOLVER_CONFIG_NAMESPACE));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error(String.format("Fail to create a DatasetResolver with factory class %s", resolverFactory));
        }
        return resolver;
    }

    private static String getKey(Object ... objects) {
        Object[] args = new Object[objects.length + 1];
        args[0] = LineageEventBuilder.LIENAGE_EVENT_NAMESPACE;
        System.arraycopy(objects, 0, args, 1, objects.length);
        return LineageEventBuilder.getKey(args);
    }
}

