/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.policy;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.data.management.retention.policy.RetentionPolicy;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.util.FileListUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@Alpha
public abstract class RawDatasetRetentionPolicy
implements RetentionPolicy<FileSystemDatasetVersion> {
    private final FileSystem fs;
    private final Class<? extends FileSystemDatasetVersion> versionClass;
    private final RetentionPolicy<FileSystemDatasetVersion> embeddedRetentionPolicy;

    public RawDatasetRetentionPolicy(FileSystem fs, Class<? extends FileSystemDatasetVersion> versionClass, RetentionPolicy<FileSystemDatasetVersion> retentionPolicy) {
        this.fs = fs;
        this.versionClass = versionClass;
        this.embeddedRetentionPolicy = retentionPolicy;
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return this.versionClass;
    }

    @Override
    public Collection<FileSystemDatasetVersion> listDeletableVersions(List<FileSystemDatasetVersion> allVersions) {
        Collection<FileSystemDatasetVersion> deletableVersions = this.embeddedRetentionPolicy.listDeletableVersions(allVersions);
        return this.listQualifiedRawFileSystemDatasetVersions(deletableVersions);
    }

    protected Collection<FileSystemDatasetVersion> listQualifiedRawFileSystemDatasetVersions(Collection<FileSystemDatasetVersion> allVersions) {
        return Lists.newArrayList((Iterable)Collections2.filter(allVersions, (Predicate)new Predicate<FileSystemDatasetVersion>(){

            public boolean apply(FileSystemDatasetVersion version) {
                Iterable<Path> refinedDatasetPaths = RawDatasetRetentionPolicy.this.getRefinedDatasetPaths(version);
                try {
                    Optional latestRawDatasetModTime = RawDatasetRetentionPolicy.this.getLatestModTime(version.getPaths());
                    Optional latestRefinedDatasetModTime = RawDatasetRetentionPolicy.this.getLatestModTime(refinedDatasetPaths);
                    return latestRawDatasetModTime.isPresent() && latestRefinedDatasetModTime.isPresent() && (Long)latestRawDatasetModTime.get() <= (Long)latestRefinedDatasetModTime.get();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to get modification time", e);
                }
            }
        }));
    }

    private Optional<Long> getLatestModTime(Iterable<Path> paths) throws IOException {
        long latestModTime = Long.MIN_VALUE;
        for (FileStatus status : FileListUtils.listMostNestedPathRecursively((FileSystem)this.fs, paths)) {
            latestModTime = Math.max(latestModTime, status.getModificationTime());
        }
        return latestModTime == Long.MIN_VALUE ? Optional.absent() : Optional.of((Object)latestModTime);
    }

    protected abstract Iterable<Path> getRefinedDatasetPaths(FileSystemDatasetVersion var1);
}

