/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.profile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.data.management.retention.dataset.ConfigurableCleanableDataset;
import org.apache.gobblin.data.management.retention.profile.ConfigurableGlobDatasetFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.util.ProxiedFileSystemCache;
import org.apache.gobblin.util.RateControlledFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ProxyableDatasetProfile
extends ConfigurableGlobDatasetFinder {
    public ProxyableDatasetProfile(FileSystem fs, Properties props) {
        super(fs, props);
    }

    public Dataset datasetAtPath(Path path) throws IOException {
        return new ConfigurableCleanableDataset(this.getFsForDataset(path), this.props, path);
    }

    public FileSystem getFsForDataset(Path path) throws IOException {
        Preconditions.checkArgument((boolean)this.props.containsKey("super.user.name.to.proxy.as.others"));
        Preconditions.checkArgument((boolean)this.props.containsKey("super.user.key.tab.location"));
        FileSystem proxiedFileSystem = this.fs;
        try {
            proxiedFileSystem = ProxiedFileSystemCache.getProxiedFileSystemUsingKeytab((String)this.fs.getFileStatus(path).getOwner(), (String)this.props.getProperty("super.user.name.to.proxy.as.others"), (Path)new Path(this.props.getProperty("super.user.key.tab.location")), (URI)this.fs.getUri(), (Configuration)this.fs.getConf());
        }
        catch (ExecutionException e) {
            throw new IOException("Cannot get proxied filesystem at Path: " + path, e);
        }
        if (this.props.contains("gobblin.retention.hdfs.calls.per.second.limit")) {
            return new RateControlledFileSystem(proxiedFileSystem, Long.parseLong(this.props.getProperty("gobblin.retention.hdfs.calls.per.second.limit")));
        }
        return proxiedFileSystem;
    }
}

