/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.trash;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gobblin.data.management.trash.GobblinProxiedTrash;
import org.apache.gobblin.data.management.trash.Trash;
import org.apache.gobblin.util.ProxiedFileSystemCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;

public class ProxiedTrash
extends Trash
implements GobblinProxiedTrash {
    private final Cache<String, Trash> trashCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final Properties properties;

    public ProxiedTrash(FileSystem fs, Properties props, String user) throws IOException {
        super(fs, props, user);
        this.properties = props;
    }

    @Override
    public boolean moveToTrashAsUser(Path path, String user) throws IOException {
        return this.getUserTrash(user).moveToTrash(path);
    }

    public boolean moveToTrashAsOwner(Path path) throws IOException {
        String owner = this.fs.getFileStatus(path).getOwner();
        return this.moveToTrashAsUser(path, owner);
    }

    public void createTrashSnapshotAsUser(String user) throws IOException {
        this.getUserTrash(user).createTrashSnapshot();
    }

    public void purgeTrashSnapshotsAsUser(String user) throws IOException {
        this.getUserTrash(user).purgeTrashSnapshots();
    }

    public void createTrashSnapshotsForAllUsers() throws IOException {
        for (String user : this.getAllUsersWithTrash()) {
            this.createTrashSnapshotAsUser(user);
        }
    }

    public void purgeTrashSnapshotsForAllUsers() throws IOException {
        for (String user : this.getAllUsersWithTrash()) {
            this.purgeTrashSnapshotsAsUser(user);
        }
    }

    protected List<String> getAllUsersWithTrash() throws IOException {
        Path trashLocationGlob = new Path(this.properties.getProperty("gobblin.trash.location").replaceAll("\\$USER", "*"));
        Pattern userPattern = Pattern.compile(this.properties.getProperty("gobblin.trash.location").replaceAll("\\$USER", "([^/])"));
        ArrayList users = Lists.newArrayList();
        for (FileStatus fileStatus : this.fs.globStatus(trashLocationGlob)) {
            Matcher matcher = userPattern.matcher(fileStatus.getPath().toString());
            if (!matcher.find()) continue;
            users.add(matcher.group(1));
        }
        return users;
    }

    protected Trash getUserTrash(final String user) throws IOException {
        if (UserGroupInformation.getCurrentUser().getShortUserName().equals(user)) {
            return this;
        }
        try {
            return (Trash)this.trashCache.get((Object)user, (Callable)new Callable<Trash>(){

                @Override
                public Trash call() throws Exception {
                    return ProxiedTrash.this.createNewTrashForUser(ProxiedTrash.this.fs, ProxiedTrash.this.properties, user);
                }
            });
        }
        catch (ExecutionException ee) {
            throw new IOException("Failed to get trash for user " + user);
        }
    }

    protected Trash createNewTrashForUser(FileSystem fs, Properties properties, String user) throws IOException {
        return new Trash(ProxiedFileSystemCache.fromProperties().referenceFS(fs).properties(properties).userNameToProxyAs(user).build(), properties, user);
    }
}

