/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.rest.TaskExecutionInfo;

public class TaskExecutionInfoArray
extends WrappingArrayTemplate<TaskExecutionInfo> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"TaskExecutionInfo\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Gobblin task execution information\",\"fields\":[{\"name\":\"jobId\",\"type\":\"string\",\"doc\":\"Job ID\"},{\"name\":\"taskId\",\"type\":\"string\",\"doc\":\"Task ID\"},{\"name\":\"startTime\",\"type\":\"long\",\"doc\":\"Task start time (epoch time)\",\"optional\":true},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"Task end time (epoch time)\",\"optional\":true},{\"name\":\"duration\",\"type\":\"long\",\"doc\":\"Task duration in milliseconds\",\"optional\":true},{\"name\":\"state\",\"type\":{\"type\":\"enum\",\"name\":\"TaskStateEnum\",\"symbols\":[\"PENDING\",\"RUNNING\",\"SUCCESSFUL\",\"COMMITTED\",\"FAILED\",\"CANCELLED\"]},\"doc\":\"Task state\",\"optional\":true},{\"name\":\"failureException\",\"type\":\"string\",\"doc\":\"Task failure exception message\",\"optional\":true},{\"name\":\"lowWatermark\",\"type\":\"long\",\"doc\":\"Low watermark\",\"optional\":true},{\"name\":\"highWatermark\",\"type\":\"long\",\"doc\":\"High watermark\",\"optional\":true},{\"name\":\"table\",\"type\":{\"type\":\"record\",\"name\":\"Table\",\"doc\":\"Gobblin table definition\",\"fields\":[{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"Table namespace\",\"optional\":true},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Table name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"TableTypeEnum\",\"symbols\":[\"SNAPSHOT_ONLY\",\"SNAPSHOT_APPEND\",\"APPEND_ONLY\"]},\"doc\":\"Table type\",\"optional\":true}]},\"doc\":\"Table definition\",\"optional\":true},{\"name\":\"taskProperties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Task properties\",\"optional\":true},{\"name\":\"metrics\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Metric\",\"doc\":\"Gobblin metric\",\"fields\":[{\"name\":\"group\",\"type\":\"string\",\"doc\":\"Metric group\"},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Metric name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"MetricTypeEnum\",\"symbols\":[\"COUNTER\",\"METER\",\"GAUGE\"]},\"doc\":\"Metric type\"},{\"name\":\"value\",\"type\":\"string\",\"doc\":\"Metric value\"}]}},\"doc\":\"Job metrics\"}]}}");

    public TaskExecutionInfoArray() {
        this(new DataList());
    }

    public TaskExecutionInfoArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public TaskExecutionInfoArray(Collection<TaskExecutionInfo> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public TaskExecutionInfoArray(DataList data) {
        super(data, SCHEMA, TaskExecutionInfo.class);
    }

    public TaskExecutionInfoArray clone() throws CloneNotSupportedException {
        return (TaskExecutionInfoArray)super.clone();
    }

    public TaskExecutionInfoArray copy() throws CloneNotSupportedException {
        return (TaskExecutionInfoArray)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public TaskExecutionInfo.Fields items() {
            return new TaskExecutionInfo.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

