/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.http;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Map;
import java.util.Queue;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.async.AsyncRequestBuilder;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.http.ApacheHttpRequest;
import org.apache.gobblin.http.HttpOperation;
import org.apache.gobblin.utils.HttpUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpRequestBuilder
implements AsyncRequestBuilder<GenericRecord, HttpUriRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpRequestBuilder.class);
    private final String urlTemplate;
    private final String verb;
    private final ContentType contentType;

    public ApacheHttpRequestBuilder(String urlTemplate, String verb, String contentType) {
        this.urlTemplate = urlTemplate;
        this.verb = verb;
        this.contentType = ApacheHttpRequestBuilder.createContentType(contentType);
    }

    public ApacheHttpRequest<GenericRecord> buildRequest(Queue<BufferedRecord<GenericRecord>> buffer) {
        return this.buildWriteRequest(buffer.poll());
    }

    private ApacheHttpRequest<GenericRecord> buildWriteRequest(BufferedRecord<GenericRecord> record) {
        int bytesWritten;
        if (record == null) {
            return null;
        }
        ApacheHttpRequest<GenericRecord> request = new ApacheHttpRequest<GenericRecord>();
        HttpOperation httpOperation = HttpUtils.toHttpOperation((GenericRecord)record.getRecord());
        URI uri = HttpUtils.buildURI(this.urlTemplate, httpOperation.getKeys(), httpOperation.getQueryParams());
        if (uri == null) {
            return null;
        }
        RequestBuilder builder = RequestBuilder.create((String)this.verb.toUpperCase());
        builder.setUri(uri);
        Map<String, String> headers = httpOperation.getHeaders();
        if (headers != null && headers.size() != 0) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                builder.setHeader(header.getKey(), header.getValue());
            }
        }
        if ((bytesWritten = this.addPayload(builder, httpOperation.getBody())) == -1) {
            throw new RuntimeException("Fail to write payload into request");
        }
        request.setRawRequest(this.build(builder));
        request.markRecord(record, bytesWritten);
        return request;
    }

    protected int addPayload(RequestBuilder builder, String payload) {
        if (payload == null || payload.length() == 0) {
            return 0;
        }
        builder.setHeader("Content-Type", this.contentType.getMimeType());
        builder.setEntity((HttpEntity)new StringEntity(payload, this.contentType));
        return payload.length();
    }

    public static ContentType createContentType(String contentType) {
        switch (contentType) {
            case "application/json": {
                return ContentType.APPLICATION_JSON;
            }
            case "text/plain": {
                return ContentType.TEXT_PLAIN;
            }
        }
        throw new RuntimeException("contentType not supported: " + contentType);
    }

    @VisibleForTesting
    public HttpUriRequest build(RequestBuilder builder) {
        return builder.build();
    }
}

