/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.stats.LongStats;
import com.linkedin.common.stats.LongTracking;
import com.linkedin.r2.RetriableRequestException;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolLifecycleStats;
import com.linkedin.r2.transport.http.client.HttpNettyStreamClient;
import com.linkedin.r2.transport.http.client.PoolStats;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.SocketAddress;

class ChannelPoolLifecycle
implements AsyncPool.Lifecycle<Channel> {
    private final SocketAddress _remoteAddress;
    private final Bootstrap _bootstrap;
    private final ChannelGroup _channelGroup;
    private final boolean _tcpNoDelay;
    private final LongTracking _createTimeTracker = new LongTracking();

    public ChannelPoolLifecycle(SocketAddress address, Bootstrap bootstrap, ChannelGroup channelGroup, boolean tcpNoDelay) {
        this._remoteAddress = address;
        this._bootstrap = bootstrap;
        this._channelGroup = channelGroup;
        this._tcpNoDelay = tcpNoDelay;
    }

    public void create(final Callback<Channel> channelCallback) {
        final long start = System.currentTimeMillis();
        this._bootstrap.connect(this._remoteAddress).addListener((GenericFutureListener)new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess()) {
                    LongTracking longTracking = ChannelPoolLifecycle.this._createTimeTracker;
                    synchronized (longTracking) {
                        ChannelPoolLifecycle.this._createTimeTracker.addValue(System.currentTimeMillis() - start);
                    }
                    Channel c = channelFuture.channel();
                    if (ChannelPoolLifecycle.this._tcpNoDelay) {
                        c.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    ChannelPoolLifecycle.this._channelGroup.add((Object)c);
                    channelCallback.onSuccess((Object)c);
                } else {
                    Throwable cause = channelFuture.cause();
                    if (cause instanceof ConnectException) {
                        channelCallback.onError((Throwable)new RetriableRequestException(cause));
                    } else {
                        channelCallback.onError((Throwable)HttpNettyStreamClient.toException(cause));
                    }
                }
            }
        });
    }

    public boolean validateGet(Channel c) {
        return c.isActive();
    }

    public boolean validatePut(Channel c) {
        return c.isActive();
    }

    public void destroy(Channel channel, boolean error, final Callback<Channel> channelCallback) {
        if (channel.isOpen()) {
            channel.close().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isSuccess()) {
                        channelCallback.onSuccess((Object)channelFuture.channel());
                    } else {
                        channelCallback.onError((Throwable)HttpNettyStreamClient.toException(channelFuture.cause()));
                    }
                }
            });
        } else {
            channelCallback.onSuccess((Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats.LifecycleStats getStats() {
        LongTracking longTracking = this._createTimeTracker;
        synchronized (longTracking) {
            LongStats stats = this._createTimeTracker.getStats();
            this._createTimeTracker.reset();
            return new AsyncPoolLifecycleStats(stats.getAverage(), stats.get50Pct(), stats.get95Pct(), stats.get99Pct());
        }
    }
}

