/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.conditions;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.compaction.conditions.RecompactionCondition;
import org.apache.gobblin.compaction.conditions.RecompactionConditionFactory;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.dataset.DatasetHelper;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="RecompactionCombineCondition")
public class RecompactionCombineCondition
implements RecompactionCondition {
    private final List<RecompactionCondition> recompactionConditions;
    private final CombineOperation operation;
    private static final Logger logger = LoggerFactory.getLogger(RecompactionCombineCondition.class);

    private RecompactionCombineCondition(Dataset dataset) {
        this.recompactionConditions = this.getConditionsFromProperties(dataset);
        this.operation = this.getConditionOperation(dataset);
        if (this.recompactionConditions.size() == 0) {
            throw new IllegalArgumentException("No combine conditions specified");
        }
    }

    public RecompactionCombineCondition(List<RecompactionCondition> conditions, CombineOperation opr) {
        this.recompactionConditions = conditions;
        this.operation = opr;
    }

    private CombineOperation getConditionOperation(Dataset dataset) {
        String oprName = dataset.jobProps().getProp("compaction.recompact.combine.conditions.operation", "or");
        try {
            CombineOperation opr = CombineOperation.valueOf(oprName.toUpperCase());
            return opr;
        }
        catch (Exception e) {
            return CombineOperation.OR;
        }
    }

    private ImmutableList<RecompactionCondition> getConditionsFromProperties(Dataset dataset) {
        ClassAliasResolver conditionClassAliasResolver = new ClassAliasResolver(RecompactionConditionFactory.class);
        List factoryNames = dataset.jobProps().getPropAsList("compaction.recompact.combine.conditions", "RecompactBasedOnRatio");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String factoryName : factoryNames) {
            try {
                RecompactionConditionFactory factory = (RecompactionConditionFactory)GobblinConstructorUtils.invokeFirstConstructor((Class)conditionClassAliasResolver.resolveClass(factoryName), (List[])new List[]{ImmutableList.of()});
                RecompactionCondition condition = factory.createRecompactionCondition(dataset);
                builder.add((Object)condition);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return builder.build();
    }

    @Override
    public boolean isRecompactionNeeded(DatasetHelper helper) {
        if (this.recompactionConditions.isEmpty()) {
            return false;
        }
        if (this.operation == CombineOperation.OR) {
            for (RecompactionCondition c : this.recompactionConditions) {
                if (!c.isRecompactionNeeded(helper)) continue;
                return true;
            }
            return false;
        }
        for (RecompactionCondition c : this.recompactionConditions) {
            if (c.isRecompactionNeeded(helper)) continue;
            return false;
        }
        return true;
    }

    @Alias(value="RecompactBasedOnCombination")
    public static class Factory
    implements RecompactionConditionFactory {
        @Override
        public RecompactionCondition createRecompactionCondition(Dataset dataset) {
            return new RecompactionCombineCondition(dataset);
        }
    }

    public static enum CombineOperation {
        OR,
        AND;

    }
}

