/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive;

public final class HiveAttribute {
    private final String name;
    private final Type type;

    public static Type fromAvroType(String avroTypeString) {
        try {
            AvroType.valueOf(avroTypeString.toUpperCase());
            return AvroType.valueOf(avroTypeString).hiveType;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public HiveAttribute(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public HiveAttribute(HiveAttribute attr) {
        this.name = attr.name;
        this.type = attr.type;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HiveAttribute)) {
            return false;
        }
        HiveAttribute other = (HiveAttribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    private static enum AvroType {
        BOOLEAN(Type.BOOLEAN),
        INT(Type.INT),
        LONG(Type.BIGINT),
        FLOAT(Type.FLOAT),
        DOUBLE(Type.DOUBLE),
        BYTES(Type.BINARY),
        STRING(Type.STRING),
        ENUM(Type.STRING);

        private final Type hiveType;

        private AvroType(Type hiveType) {
            this.hiveType = hiveType;
        }
    }

    public static enum Type {
        TINYINT,
        SMALLINT,
        INT,
        BIGINT,
        FLOAT,
        DOUBLE,
        DECIMAL,
        TIMESTAMP,
        DATE,
        STRING,
        VARCHAR,
        CHAR,
        BOOLEAN,
        BINARY;

    }
}

