/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hive;

import java.sql.SQLException;
import org.apache.gobblin.compaction.hive.HiveAttribute;
import org.apache.gobblin.compaction.hive.HiveTable;
import org.apache.gobblin.util.HiveJdbcConnector;

public class HiveManagedTable
extends HiveTable {
    private HiveManagedTable(Builder builder) {
        super(builder);
    }

    public void createTable(HiveJdbcConnector conn, String jobId, String tableType) throws SQLException {
        String tableName = this.getNameWithJobId(jobId);
        String dropTableStmt = String.format("DROP TABLE IF EXISTS %1$s", tableName);
        StringBuilder sb = new StringBuilder().append("CREATE ");
        sb.append(tableType + " ");
        sb.append(tableName);
        sb.append('(');
        for (int i = 0; i < this.attributes.size(); ++i) {
            sb.append(((HiveAttribute)this.attributes.get(i)).name() + " " + (Object)((Object)((HiveAttribute)this.attributes.get(i)).type()));
            if (i == this.attributes.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        String createTableStmt = sb.toString();
        conn.executeStatements(new String[]{dropTableStmt, createTableStmt});
    }

    @Override
    public void createTable(HiveJdbcConnector conn, String randomSuffix) throws SQLException {
        this.createTable(conn, randomSuffix, "TABLE");
    }

    public void createTemporaryTable(HiveJdbcConnector conn, String randomSuffix) throws SQLException {
        this.createTable(conn, randomSuffix, "TEMPORARY TABLE");
    }

    @Override
    public HiveTable addNewColumnsInSchema(HiveJdbcConnector conn, HiveTable table, String randomSuffix) throws SQLException {
        if (this.hasNoNewColumn(table)) {
            return this;
        }
        StringBuilder sb = new StringBuilder().append("ALTER TABLE " + this.getNameWithJobId(randomSuffix) + " ADD COLUMNS (");
        boolean addComma = false;
        for (HiveAttribute attribute : table.attributes) {
            if (this.attributes.contains(attribute)) continue;
            if (addComma) {
                sb.append(", ");
            }
            sb.append(attribute.name() + " " + (Object)((Object)attribute.type()));
            addComma = true;
            this.attributes.add(attribute);
        }
        sb.append(')');
        String alterTableStmt = sb.toString();
        conn.executeStatements(new String[]{alterTableStmt});
        return this;
    }

    public static class Builder
    extends HiveTable.Builder<Builder> {
        public HiveManagedTable build() {
            return new HiveManagedTable(this);
        }
    }
}

