/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.listeners;

import java.util.Set;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.listeners.CompactorCompletionListener;
import org.apache.gobblin.compaction.listeners.CompactorCompletionListenerFactory;
import org.apache.gobblin.compaction.mapreduce.MRCompactor;
import org.apache.gobblin.configuration.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCompactorCompletionListener
implements CompactorCompletionListener {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCompactorCompletionListener.class);

    private SimpleCompactorCompletionListener(State state) {
    }

    @Override
    public void onCompactionCompletion(MRCompactor compactor) {
        logger.info(String.format("Compaction (started on : %s) is finished", compactor.getInitializeTime()));
        Set<Dataset> datasets = compactor.getDatasets();
        for (Dataset dataset : datasets) {
            if (dataset.state() == Dataset.DatasetState.COMPACTION_COMPLETE) continue;
            logger.error("Dataset " + dataset.getDatasetName() + " " + dataset.state().name());
        }
    }

    @Alias(value="SimpleCompactorCompletionHook")
    public static class Factory
    implements CompactorCompletionListenerFactory {
        @Override
        public CompactorCompletionListener createCompactorCompactionListener(State state) {
            return new SimpleCompactorCompletionListener(state);
        }
    }
}

