/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.common.base.Optional;
import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.transport.common.Client;
import com.linkedin.r2.transport.common.bridge.client.TransportClientAdapter;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.restli.client.CreateIdRequest;
import com.linkedin.restli.client.DeleteRequest;
import com.linkedin.restli.client.GetRequest;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.ResponseFuture;
import com.linkedin.restli.client.RestClient;
import com.linkedin.restli.client.UpdateRequest;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.EmptyRecord;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import org.apache.gobblin.service.FlowConfig;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.FlowconfigsCreateRequestBuilder;
import org.apache.gobblin.service.FlowconfigsDeleteRequestBuilder;
import org.apache.gobblin.service.FlowconfigsGetRequestBuilder;
import org.apache.gobblin.service.FlowconfigsRequestBuilders;
import org.apache.gobblin.service.FlowconfigsUpdateRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowConfigClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FlowConfigClient.class);
    private Optional<HttpClientFactory> _httpClientFactory;
    private Optional<RestClient> _restClient;
    private final FlowconfigsRequestBuilders _flowconfigsRequestBuilders;

    public FlowConfigClient(String serverUri) {
        LOG.debug("FlowConfigClient with serverUri " + serverUri);
        this._httpClientFactory = Optional.of((Object)new HttpClientFactory());
        TransportClientAdapter r2Client = new TransportClientAdapter(((HttpClientFactory)this._httpClientFactory.get()).getClient(Collections.emptyMap()));
        this._restClient = Optional.of((Object)new RestClient((Client)r2Client, serverUri));
        this._flowconfigsRequestBuilders = new FlowconfigsRequestBuilders();
    }

    public FlowConfigClient(RestClient restClient) {
        LOG.debug("FlowConfigClient with restClient " + restClient);
        this._httpClientFactory = Optional.absent();
        this._restClient = Optional.of((Object)restClient);
        this._flowconfigsRequestBuilders = new FlowconfigsRequestBuilders();
    }

    public void createFlowConfig(FlowConfig flowConfig) throws RemoteInvocationException {
        LOG.debug("createFlowConfig with groupName " + flowConfig.getId().getFlowGroup() + " flowName " + flowConfig.getId().getFlowName());
        CreateIdRequest request = ((FlowconfigsCreateRequestBuilder)this._flowconfigsRequestBuilders.create().input((RecordTemplate)flowConfig)).build();
        ResponseFuture flowConfigResponseFuture = ((RestClient)this._restClient.get()).sendRequest((Request)request);
        flowConfigResponseFuture.getResponse();
    }

    public void updateFlowConfig(FlowConfig flowConfig) throws RemoteInvocationException {
        LOG.debug("updateFlowConfig with groupName " + flowConfig.getId().getFlowGroup() + " flowName " + flowConfig.getId().getFlowName());
        FlowId flowId = new FlowId().setFlowGroup(flowConfig.getId().getFlowGroup()).setFlowName(flowConfig.getId().getFlowName());
        UpdateRequest updateRequest = ((FlowconfigsUpdateRequestBuilder)((FlowconfigsUpdateRequestBuilder)this._flowconfigsRequestBuilders.update().id((Object)new ComplexResourceKey((RecordTemplate)flowId, (RecordTemplate)new EmptyRecord()))).input((RecordTemplate)flowConfig)).build();
        ResponseFuture response = ((RestClient)this._restClient.get()).sendRequest((Request)updateRequest);
        response.getResponse();
    }

    public FlowConfig getFlowConfig(FlowId flowId) throws RemoteInvocationException {
        LOG.debug("getFlowConfig with groupName " + flowId.getFlowGroup() + " flowName " + flowId.getFlowName());
        GetRequest getRequest = ((FlowconfigsGetRequestBuilder)this._flowconfigsRequestBuilders.get().id((Object)new ComplexResourceKey((RecordTemplate)flowId, (RecordTemplate)new EmptyRecord()))).build();
        Response response = ((RestClient)this._restClient.get()).sendRequest((Request)getRequest).getResponse();
        return (FlowConfig)response.getEntity();
    }

    public void deleteFlowConfig(FlowId flowId) throws RemoteInvocationException {
        LOG.debug("deleteFlowConfig with groupName " + flowId.getFlowGroup() + " flowName " + flowId.getFlowName());
        DeleteRequest deleteRequest = ((FlowconfigsDeleteRequestBuilder)this._flowconfigsRequestBuilders.delete().id((Object)new ComplexResourceKey((RecordTemplate)flowId, (RecordTemplate)new EmptyRecord()))).build();
        ResponseFuture response = ((RestClient)this._restClient.get()).sendRequest((Request)deleteRequest);
        response.getResponse();
    }

    @Override
    public void close() throws IOException {
        if (this._restClient.isPresent()) {
            ((RestClient)this._restClient.get()).shutdown((Callback)new FutureCallback());
        }
        if (this._httpClientFactory.isPresent()) {
            ((HttpClientFactory)this._httpClientFactory.get()).shutdown((Callback)new FutureCallback());
        }
    }
}

