/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.methods.arguments;

import com.linkedin.data.DataMap;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.PatchRequest;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.methods.arguments.ArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.server.BatchPatchRequest;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.RestLiRequestDataImpl;
import java.util.Map;
import java.util.Set;

public class BatchPatchArgumentBuilder
implements RestLiArgumentBuilder {
    @Override
    public Object[] buildArguments(RestLiRequestData requestData, RoutingResult routingResult) {
        BatchPatchRequest batchRequest = new BatchPatchRequest(requestData.getBatchKeyEntityMap());
        Object[] positionalArgs = new Object[]{batchRequest};
        return ArgumentBuilder.buildArgs(positionalArgs, routingResult.getResourceMethod(), routingResult.getContext(), null);
    }

    @Override
    public RestLiRequestData extractRequestData(RoutingResult routingResult, RestRequest request) {
        DataMap dataMap = DataMapUtils.readMap((RestMessage)request);
        Set ids = routingResult.getContext().getPathKeys().getBatchIds();
        Map<Object, PatchRequest> inputMap = ArgumentBuilder.buildBatchRequestMap(routingResult, dataMap, PatchRequest.class, ids, ProtocolVersionUtil.extractProtocolVersion((Map)request.getHeaders()));
        RestLiRequestDataImpl.Builder builder = new RestLiRequestDataImpl.Builder();
        if (inputMap != null) {
            builder.batchKeyEntityMap(inputMap);
        }
        return builder.build();
    }
}

