/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.server.ResourceConfigException;
import com.linkedin.restli.server.annotations.RestLiActions;
import com.linkedin.restli.server.annotations.RestLiAssociation;
import com.linkedin.restli.server.annotations.RestLiCollection;
import com.linkedin.restli.server.annotations.RestLiSimpleResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

class RestLiClasspathScanner {
    public static final String CLASS_SUFFIX = ".class";
    public static final char PACKAGE_SEPARATOR = '.';
    public static final char FILE_SEPARATOR = File.separatorChar;
    public static final char UNIX_FILE_SEPARATOR = '/';
    public static final String SCHEME_FILE = "file";
    public static final String SCHEME_JAR = "jar";
    public static final String SCHEME_ZIP = "zip";
    public static final char JAR_ENTRY_DELIMITER = '!';
    private static final Set<Class<? extends Annotation>> _annotations = RestLiClasspathScanner.buildAnnotations();
    private final Set<Class<?>> _matchedClasses;
    private final ClassLoader _classLoader;
    private final Set<String> _packagePaths;
    private final Set<String> _classNames;

    private static Set<Class<? extends Annotation>> buildAnnotations() {
        HashSet<Class> annotations = new HashSet<Class>();
        annotations.add(RestLiCollection.class);
        annotations.add(RestLiAssociation.class);
        annotations.add(RestLiActions.class);
        annotations.add(RestLiSimpleResource.class);
        return Collections.unmodifiableSet(annotations);
    }

    public RestLiClasspathScanner(Set<String> packageNames, Set<String> classNames, ClassLoader classLoader) {
        this._classLoader = classLoader;
        this._packagePaths = new HashSet<String>();
        for (String packageName : packageNames) {
            this._packagePaths.add(this.nameToPath(packageName));
        }
        this._classNames = classNames;
        this._matchedClasses = new HashSet();
    }

    private String nameToPath(String name) {
        return name.replace('.', FILE_SEPARATOR);
    }

    private String pathToName(String path) {
        return path.replace(FILE_SEPARATOR, '.');
    }

    private String toUnixPath(String path) {
        return path.replace(FILE_SEPARATOR, '/');
    }

    private String toNativePath(String path) {
        return path.replace('/', FILE_SEPARATOR);
    }

    public Class<?> classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this._classLoader);
    }

    public Set<Class<?>> getMatchedClasses() {
        return this._matchedClasses;
    }

    public void scanPackages() {
        try {
            for (String p : this._packagePaths) {
                Enumeration<URL> resources = this._classLoader.getResources(this.toUnixPath(p));
                while (resources.hasMoreElements()) {
                    URI u = resources.nextElement().toURI();
                    String scheme = u.getScheme().toLowerCase();
                    if (scheme.equals(SCHEME_JAR) || scheme.equals(SCHEME_ZIP)) {
                        this.scanJar(u);
                        continue;
                    }
                    if (scheme.equals(SCHEME_FILE)) {
                        this.scanDirectory(new File(u.getPath()));
                        continue;
                    }
                    throw new ResourceConfigException("Unable to scan resource '" + u.toString() + "'. URI scheme not supported by scanner.");
                }
            }
        }
        catch (IOException e) {
            throw new ResourceConfigException("Unable to scan resources", e);
        }
        catch (URISyntaxException e) {
            throw new ResourceConfigException("Unable to scan resources", e);
        }
    }

    public String scanClasses() {
        StringBuilder errorBuilder = new StringBuilder();
        block2: for (String c : this._classNames) {
            try {
                Class<?> candidateClass = this.classForName(c);
                for (Annotation a : candidateClass.getAnnotations()) {
                    if (!_annotations.contains(a.annotationType())) continue;
                    this._matchedClasses.add(candidateClass);
                    continue block2;
                }
            }
            catch (ClassNotFoundException e) {
                errorBuilder.append(String.format("Failed to load class %s\n", c));
            }
        }
        return errorBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(URI u) throws IOException {
        String ssp = u.getRawSchemeSpecificPart();
        URL jarUrl = new URL(ssp.substring(0, ssp.lastIndexOf(33)));
        InputStream in = null;
        ZipInputStream jarIn = null;
        try {
            in = jarUrl.openStream();
            jarIn = new JarInputStream(in);
            String parent = ssp.substring(ssp.lastIndexOf(33) + 2);
            JarEntry e = ((JarInputStream)jarIn).getNextJarEntry();
            while (e != null) {
                if (!e.isDirectory() && e.getName().startsWith(parent)) {
                    this.checkForMatchingClass(this.toNativePath(e.getName()));
                }
                jarIn.closeEntry();
                e = ((JarInputStream)jarIn).getNextJarEntry();
            }
        }
        finally {
            if (jarIn != null) {
                jarIn.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void scanDirectory(File root) {
        if (!root.isDirectory()) {
            return;
        }
        for (File child : root.listFiles()) {
            if (child.isDirectory()) {
                this.scanDirectory(child);
                continue;
            }
            this.checkForMatchingClass(child.getAbsolutePath());
        }
    }

    public void checkForMatchingClass(String name) {
        if (name.endsWith(CLASS_SUFFIX)) {
            block2: for (String packagePath : this._packagePaths) {
                if (!name.contains(packagePath)) continue;
                int start = name.lastIndexOf(packagePath);
                int end = name.lastIndexOf(CLASS_SUFFIX);
                String clazzPath = name.substring(start, end);
                String clazzName = this.pathToName(clazzPath);
                try {
                    Class<?> clazz = this.classForName(clazzName);
                    for (Annotation a : clazz.getAnnotations()) {
                        if (!_annotations.contains(a.annotationType())) continue;
                        this._matchedClasses.add(clazz);
                        continue block2;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RestLiInternalException("Failed to load class while scanning packages", e);
                }
            }
        }
    }
}

