/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.ErrorDetails;
import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.internal.common.HeaderUtil;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.response.EnvelopeBuilderUtil;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.server.ErrorResponseFormat;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;

public final class ErrorResponseBuilder
implements RestLiResponseBuilder {
    public static final String DEFAULT_INTERNAL_ERROR_MESSAGE = "INTERNAL SERVER ERROR";
    private final ErrorResponseFormat _errorResponseFormat;
    private final String _internalErrorMessage;

    public ErrorResponseBuilder() {
        this(ErrorResponseFormat.defaultFormat());
    }

    public ErrorResponseBuilder(ErrorResponseFormat errorResponseFormat) {
        this(errorResponseFormat, DEFAULT_INTERNAL_ERROR_MESSAGE);
    }

    public ErrorResponseBuilder(ErrorResponseFormat errorResponseFormat, String internalErrorMessage) {
        this._errorResponseFormat = errorResponseFormat;
        this._internalErrorMessage = internalErrorMessage;
    }

    public String getInternalErrorMessage() {
        return this._internalErrorMessage;
    }

    public ErrorResponse buildErrorResponse(RestLiServiceException result) {
        return this.buildErrorResponse(result, result.hasOverridingErrorResponseFormat() ? result.getOverridingFormat() : this._errorResponseFormat);
    }

    private ErrorResponse buildErrorResponse(RestLiServiceException result, ErrorResponseFormat errorResponseFormat) {
        ErrorResponse er = new ErrorResponse();
        if (errorResponseFormat.showStatusCodeInBody()) {
            er.setStatus(result.getStatus().getCode());
        }
        if (errorResponseFormat.showMessage() && result.getMessage() != null) {
            er.setMessage(result.getMessage());
        }
        if (errorResponseFormat.showServiceErrorCode() && result.hasServiceErrorCode()) {
            er.setServiceErrorCode(result.getServiceErrorCode());
        }
        if (errorResponseFormat.showDetails() && result.hasErrorDetails()) {
            er.setErrorDetails(new ErrorDetails(result.getErrorDetails()));
        }
        if (errorResponseFormat.showStacktrace()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            result.printStackTrace(pw);
            er.setStackTrace(sw.toString());
            er.setExceptionClass(result.getClass().getName());
        }
        if (errorResponseFormat.showExceptionClass()) {
            er.setExceptionClass(result.getClass().getName());
        }
        return er;
    }

    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        ErrorResponse errorResponse = this.buildErrorResponse(responseData.getServiceException());
        return new PartialRestResponse.Builder().headers(responseData.getHeaders()).cookies(responseData.getCookies()).status(responseData.getStatus()).entity((RecordTemplate)errorResponse).build();
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object object, Map<String, String> headers, List<HttpCookie> cookies) {
        RestLiServiceException exceptionResult = (RestLiServiceException)object;
        if (this._errorResponseFormat.showHeaders()) {
            ProtocolVersion protocolVersion = ProtocolVersionUtil.extractProtocolVersion(headers);
            headers.put(HeaderUtil.getErrorResponseHeaderName((ProtocolVersion)protocolVersion), "true");
        }
        if (routingResult == null || routingResult.getResourceMethod() == null) {
            RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(exceptionResult, headers, cookies);
            return responseData;
        }
        ResourceMethod type = routingResult.getResourceMethod().getMethodType();
        RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(exceptionResult, headers, cookies);
        responseData.setResponseEnvelope(EnvelopeBuilderUtil.buildBlankResponseEnvelope(type, responseData));
        return responseData;
    }
}

