/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.restli.server.ErrorResponseFormat;
import com.linkedin.restli.server.RestLiDebugRequestHandler;
import com.linkedin.restli.server.RestLiDocumentationRequestHandler;
import com.linkedin.restli.server.filter.Filter;
import com.linkedin.restli.server.multiplexer.MultiplexerRunMode;
import com.linkedin.restli.server.multiplexer.MultiplexerSingletonFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RestLiConfig {
    private static final int DEFAULT_MAX_REQUESTS_MULTIPLEXED = 20;
    private final Set<String> _resourcePackageNames = new HashSet<String>();
    private final Set<String> _resourceClassNames = new HashSet<String>();
    private URI _serverNodeUri = URI.create("");
    private RestLiDocumentationRequestHandler _documentationRequestHandler = null;
    private ErrorResponseFormat _errorResponseFormat = ErrorResponseFormat.FULL;
    private String _internalErrorMessage = "INTERNAL SERVER ERROR";
    private RestliProtocolCheck _restliProtocolCheck = RestliProtocolCheck.STRICT;
    private List<RestLiDebugRequestHandler> _debugRequestHandlers;
    private final List<Filter> _filters = new ArrayList<Filter>();
    private int _maxRequestsMultiplexed = 20;
    private Set<String> _individualRequestHeaderWhitelist = Collections.emptySet();
    private MultiplexerSingletonFilter _multiplexerSingletonFilter;
    private MultiplexerRunMode _multiplexerRunMode = MultiplexerRunMode.MULTIPLE_PLANS;

    public RestLiConfig() {
        this(Collections.emptyMap());
    }

    public RestLiConfig(Map<String, Object> mapConfig) {
        this._debugRequestHandlers = new ArrayList<RestLiDebugRequestHandler>();
    }

    public Set<String> getResourcePackageNamesSet() {
        return Collections.unmodifiableSet(this._resourcePackageNames);
    }

    public Set<String> getResourceClassNamesSet() {
        return Collections.unmodifiableSet(this._resourceClassNames);
    }

    public void setResourcePackageNames(String commaDelimitedResourcePackageNames) {
        if (commaDelimitedResourcePackageNames != null && !"".equals(commaDelimitedResourcePackageNames.trim())) {
            this._resourcePackageNames.clear();
            this.addResourcePackageNames(commaDelimitedResourcePackageNames.split(","));
        }
    }

    public void setResourcePackageNamesSet(Set<String> packageNames) {
        if (packageNames != null && !packageNames.isEmpty()) {
            this._resourcePackageNames.clear();
            this._resourcePackageNames.addAll(packageNames);
        }
    }

    public void addResourcePackageNames(Collection<String> packageNames) {
        this._resourcePackageNames.addAll(packageNames);
    }

    public void addResourcePackageNames(String ... packageNames) {
        this._resourcePackageNames.addAll(Arrays.asList(packageNames));
    }

    public void setResourceClassNamesSet(Set<String> classNames) {
        if (classNames != null && !classNames.isEmpty()) {
            this._resourceClassNames.clear();
            this._resourceClassNames.addAll(classNames);
        }
    }

    public void addResourceClassNames(Collection<String> classNames) {
        this._resourceClassNames.addAll(classNames);
    }

    public void addResourceClassNames(String ... classNames) {
        this._resourceClassNames.addAll(Arrays.asList(classNames));
    }

    public URI getServerNodeUri() {
        return this._serverNodeUri;
    }

    public void setServerNodeUri(URI serverNodeUri) {
        this._serverNodeUri = serverNodeUri;
    }

    public RestLiDocumentationRequestHandler getDocumentationRequestHandler() {
        return this._documentationRequestHandler;
    }

    public void setDocumentationRequestHandler(RestLiDocumentationRequestHandler handler) {
        this._documentationRequestHandler = handler;
    }

    public List<RestLiDebugRequestHandler> getDebugRequestHandlers() {
        return this._debugRequestHandlers;
    }

    public void addDebugRequestHandlers(RestLiDebugRequestHandler ... handlers) {
        this._debugRequestHandlers.addAll(Arrays.asList(handlers));
    }

    public void addDebugRequestHandlers(Collection<RestLiDebugRequestHandler> handlers) {
        this._debugRequestHandlers.addAll(handlers);
    }

    public void setDebugRequestHandlers(List<RestLiDebugRequestHandler> handlers) {
        this._debugRequestHandlers = new ArrayList<RestLiDebugRequestHandler>(handlers);
    }

    public MultiplexerSingletonFilter getMultiplexerSingletonFilter() {
        return this._multiplexerSingletonFilter;
    }

    public void setMultiplexerSingletonFilter(MultiplexerSingletonFilter multiplexerSingletonFilter) {
        this._multiplexerSingletonFilter = multiplexerSingletonFilter;
    }

    public ErrorResponseFormat getErrorResponseFormat() {
        return this._errorResponseFormat;
    }

    public void setErrorResponseFormat(ErrorResponseFormat errorResponseFormat) {
        this._errorResponseFormat = errorResponseFormat;
    }

    public String getInternalErrorMessage() {
        return this._internalErrorMessage;
    }

    public void setInternalErrorMessage(String internalErrorMessage) {
        this._internalErrorMessage = internalErrorMessage;
    }

    @Deprecated
    public void setRestliProtocolCheck(RestliProtocolCheck restliProtocolCheck) {
        if (restliProtocolCheck == null) {
            throw new IllegalArgumentException("Cannot be null!");
        }
        this._restliProtocolCheck = restliProtocolCheck;
    }

    @Deprecated
    public RestliProtocolCheck getRestliProtocolCheck() {
        return this._restliProtocolCheck;
    }

    public void addFilter(Filter ... filters) {
        this._filters.addAll(Arrays.asList(filters));
    }

    public List<Filter> getFilters() {
        return this._filters;
    }

    public void setFilters(List<? extends Filter> filters) {
        if (filters != null) {
            this._filters.clear();
            this._filters.addAll(filters);
        }
    }

    public int getMaxRequestsMultiplexed() {
        return this._maxRequestsMultiplexed;
    }

    public void setMaxRequestsMultiplexed(int maxRequestsMultiplexed) {
        this._maxRequestsMultiplexed = maxRequestsMultiplexed;
    }

    public Set<String> getMultiplexedIndividualRequestHeaderWhitelist() {
        return this._individualRequestHeaderWhitelist;
    }

    public void setMultiplexedIndividualRequestHeaderWhitelist(Set<String> headerNames) {
        this._individualRequestHeaderWhitelist = headerNames != null ? headerNames : Collections.emptySet();
    }

    public MultiplexerRunMode getMultiplexerRunMode() {
        return this._multiplexerRunMode;
    }

    public void setMultiplexerRunMode(MultiplexerRunMode multiplexerRunMode) {
        this._multiplexerRunMode = multiplexerRunMode;
    }

    @Deprecated
    public static enum RestliProtocolCheck {
        RELAXED,
        STRICT;

    }
}

