/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.restli.common.multiplexer.IndividualRequest;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.multiplexer.IndividualResponseException;
import com.linkedin.restli.server.multiplexer.MultiplexerSingletonFilter;

final class RequestFilterTask
extends BaseTask<IndividualRequest> {
    private final MultiplexerSingletonFilter _multiplexerSingletonFilter;
    private final BaseTask<IndividualRequest> _individualRequest;

    RequestFilterTask(MultiplexerSingletonFilter multiplexerSingletonFilter, BaseTask<IndividualRequest> individualRequest) {
        this._multiplexerSingletonFilter = multiplexerSingletonFilter;
        this._individualRequest = individualRequest;
    }

    protected Promise<? extends IndividualRequest> run(Context context) throws Throwable {
        if (this._individualRequest.isFailed()) {
            return Promises.error((Throwable)this._individualRequest.getError());
        }
        IndividualRequest individualRequest = (IndividualRequest)this._individualRequest.get();
        if (this._multiplexerSingletonFilter != null) {
            try {
                return Promises.value((Object)this._multiplexerSingletonFilter.filterIndividualRequest(individualRequest));
            }
            catch (RestLiServiceException e) {
                return Promises.error((Throwable)new IndividualResponseException(e));
            }
            catch (Exception e) {
                return Promises.error((Throwable)e);
            }
        }
        return Promises.value((Object)individualRequest);
    }
}

