/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.Compressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class Bzip2Compressor
implements Compressor {
    private static final String HTTP_NAME = "bzip2";

    @Override
    public String getContentEncodingName() {
        return HTTP_NAME;
    }

    @Override
    public byte[] inflate(InputStream data) throws CompressionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BZip2CompressorInputStream bzip2 = null;
        try {
            bzip2 = new BZip2CompressorInputStream(data);
            IOUtils.copy((InputStream)bzip2, (OutputStream)out);
        }
        catch (IOException e) {
            throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
        }
        finally {
            if (bzip2 != null) {
                IOUtils.closeQuietly((InputStream)bzip2);
            }
        }
        return out.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] deflate(InputStream data) throws CompressionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BZip2CompressorOutputStream compressor = null;
        try {
            out = new ByteArrayOutputStream();
            compressor = new BZip2CompressorOutputStream((OutputStream)out);
            IOUtils.copy((InputStream)data, (OutputStream)compressor);
            compressor.finish();
            if (compressor == null) return out.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
            }
            catch (Throwable throwable) {
                if (compressor == null) throw throwable;
                IOUtils.closeQuietly(compressor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)compressor);
        return out.toByteArray();
    }
}

