/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.CompressionConfig;
import com.linkedin.r2.filter.CompressionOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCompressionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCompressionHelper.class);
    public static final String COMPRESS_ALL_RESPONSES_INDICATOR = "*";
    private static final String FAMILY_SEPARATOR = ":";
    private static final String COMPRESS_ALL_IN_FAMILY = ":*";
    private final CompressionConfig _requestCompressionConfig;
    private final Set<String> _responseCompressionMethods = new HashSet<String>();
    private final Set<String> _responseCompressionFamilies = new HashSet<String>();
    private final boolean _compressAllResponses;

    public ClientCompressionHelper(CompressionConfig requestCompressionConfig, List<String> responseCompressionOperations) {
        this._requestCompressionConfig = requestCompressionConfig;
        this.buildResponseCompressionMethodsAndFamiliesSet(responseCompressionOperations);
        this._compressAllResponses = this._responseCompressionMethods.contains(COMPRESS_ALL_RESPONSES_INDICATOR);
    }

    public boolean shouldCompressRequest(int entityLength, CompressionOption requestCompressionOverride) {
        if (requestCompressionOverride != null) {
            return requestCompressionOverride == CompressionOption.FORCE_ON;
        }
        return entityLength > this._requestCompressionConfig.getCompressionThreshold();
    }

    public boolean shouldCompressResponseForOperation(String operation) {
        if (this._compressAllResponses) {
            return true;
        }
        if (operation == null) {
            return false;
        }
        return this._responseCompressionMethods.contains(operation) || this.isMemberOfCompressionFamily(operation);
    }

    private boolean isMemberOfCompressionFamily(String operation) {
        if (operation.contains(FAMILY_SEPARATOR)) {
            String[] parts = operation.split(FAMILY_SEPARATOR);
            if (parts == null || parts.length != 2) {
                return false;
            }
            String family = parts[0];
            return this._responseCompressionFamilies.contains(family);
        }
        return false;
    }

    private void buildResponseCompressionMethodsAndFamiliesSet(List<String> responseCompressionOperations) {
        for (String operation : responseCompressionOperations) {
            if (operation.endsWith(COMPRESS_ALL_IN_FAMILY)) {
                String[] parts = operation.split(FAMILY_SEPARATOR);
                if (parts == null || parts.length != 2) {
                    LOG.warn("Illegal compression operation family " + operation + " specified");
                    return;
                }
                this._responseCompressionFamilies.add(parts[0].trim());
                continue;
            }
            this._responseCompressionMethods.add(operation);
        }
    }
}

