/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression.streaming;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

class BufferedReaderInputStream
extends InputStream
implements Reader {
    private static final int CAPACITY = 3;
    private static final ByteString EOS = ByteString.copy((byte[])new byte[1]);
    private final BlockingQueue<ByteString> _buffers = new ArrayBlockingQueue<ByteString>(4);
    private boolean _closed = false;
    private volatile boolean _readFinished = false;
    private volatile Throwable _throwable = null;
    private byte[] _buffer = null;
    private int _readIndex = 0;
    private ReadHandle _rh;

    BufferedReaderInputStream() {
    }

    @Override
    public int read() throws IOException {
        if (this._throwable != null) {
            throw new IOException(this._throwable);
        }
        if (this.done()) {
            return -1;
        }
        if (this._buffer != null) {
            int b = this._buffer[this._readIndex++] & 0xFF;
            if (this._readIndex >= this._buffer.length) {
                this._buffer = null;
                this._readIndex = 0;
            }
            return b;
        }
        try {
            ByteString data = this._buffers.take();
            if (data != EOS) {
                this._buffer = data.copyBytes();
                this._rh.request(1);
            }
        }
        catch (InterruptedException ex) {
            this._throwable = ex;
        }
        return this.read();
    }

    @Override
    public int available() {
        int avail = this._buffer == null ? 0 : this._buffer.length - this._readIndex;
        for (ByteString b : this._buffers) {
            avail += b.length();
        }
        return avail;
    }

    @Override
    public void close() {
        this._closed = true;
        this._rh.cancel();
    }

    private boolean done() {
        return this._closed || this._readFinished && this._buffer == null && this._buffers.isEmpty();
    }

    public void onInit(ReadHandle rh) {
        this._rh = rh;
        this._rh.request(3);
    }

    public void onDataAvailable(ByteString data) {
        this._buffers.add(data);
    }

    public void onDone() {
        this._readFinished = true;
        this._buffers.add(EOS);
    }

    public void onError(Throwable e) {
        this._throwable = e;
        this._buffers.add(EOS);
    }
}

