/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metadata;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.gobblin.metadata.types.GlobalMetadata;

public class GlobalMetadataCollector {
    public static final int UNLIMITED_SIZE = -1;
    private final LinkedHashSet<GlobalMetadata> metadataRecords;
    private final GlobalMetadata defaultMetadata;
    private final int cacheSize;
    private String lastSeenMetadataId;

    public GlobalMetadataCollector(int cacheSize) {
        this(null, cacheSize);
    }

    public GlobalMetadataCollector(GlobalMetadata defaultMetadata, int cacheSize) {
        Preconditions.checkArgument((cacheSize == -1 || cacheSize > 0 ? 1 : 0) != 0, (Object)"cacheSize must be -1 or greater than 0");
        this.defaultMetadata = defaultMetadata;
        this.cacheSize = cacheSize;
        this.lastSeenMetadataId = "";
        this.metadataRecords = new LinkedHashSet();
    }

    public synchronized GlobalMetadata processMetadata(GlobalMetadata metadata) {
        GlobalMetadata recordToAdd = this.getRecordToAdd(metadata);
        if (recordToAdd != null) {
            boolean isNew = this.addRecordAndEvictIfNecessary(recordToAdd);
            return isNew ? recordToAdd : null;
        }
        return null;
    }

    public Set<GlobalMetadata> getMetadataRecords() {
        return Collections.unmodifiableSet(this.metadataRecords);
    }

    private boolean addRecordAndEvictIfNecessary(GlobalMetadata recordToAdd) {
        boolean isNew = !this.metadataRecords.remove(recordToAdd);
        this.metadataRecords.add(recordToAdd);
        if (this.cacheSize != -1 && this.metadataRecords.size() > this.cacheSize) {
            Iterator recordIt = this.metadataRecords.iterator();
            recordIt.next();
            recordIt.remove();
        }
        return isNew;
    }

    private GlobalMetadata getRecordToAdd(GlobalMetadata metadata) {
        if (metadata == null) {
            return this.defaultMetadata;
        }
        if (metadata.getId().equals(this.lastSeenMetadataId)) {
            return null;
        }
        this.lastSeenMetadataId = metadata.getId();
        if (this.defaultMetadata != null) {
            metadata.mergeWithDefaults(this.defaultMetadata);
        }
        return metadata;
    }
}

