/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.commit;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.commit.CommitSequence;
import org.apache.gobblin.commit.CommitSequenceStore;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.filters.HiddenFilter;
import org.apache.gobblin.util.io.GsonInterfaceAdapter;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

@Alpha
public class FsCommitSequenceStore
implements CommitSequenceStore {
    public static final String GOBBLIN_RUNTIME_COMMIT_SEQUENCE_STORE_FS_URI = "gobblin.runtime.commit.sequence.store.fs.uri";
    public static final String GOBBLIN_RUNTIME_COMMIT_SEQUENCE_STORE_DIR = "gobblin.runtime.commit.sequence.store.dir";
    private static final String DEFAULT_DATASET_URN = "default_dataset_urn";
    private static final Gson GSON = GsonInterfaceAdapter.getGson(CommitStep.class);
    private final FileSystem fs;
    private final Path rootPath;

    public FsCommitSequenceStore(FileSystem fs, Path rootPath) {
        this.fs = fs;
        this.rootPath = rootPath;
    }

    public boolean exists(String jobName) throws IOException {
        Path jobPath = new Path(this.rootPath, jobName);
        return this.fs.exists(jobPath);
    }

    public boolean exists(String jobName, String datasetUrn) throws IOException {
        Path datasetPath = new Path(new Path(this.rootPath, jobName), FsCommitSequenceStore.sanitizeDatasetUrn(datasetUrn));
        return this.fs.exists(datasetPath);
    }

    public void delete(String jobName) throws IOException {
        Path jobPath = new Path(this.rootPath, jobName);
        HadoopUtils.deletePathAndEmptyAncestors((FileSystem)this.fs, (Path)jobPath, (boolean)true);
    }

    public void delete(String jobName, String datasetUrn) throws IOException {
        Path jobPath = new Path(this.rootPath, jobName);
        Path datasetPath = new Path(jobPath, FsCommitSequenceStore.sanitizeDatasetUrn(datasetUrn));
        HadoopUtils.deletePathAndEmptyAncestors((FileSystem)this.fs, (Path)datasetPath, (boolean)true);
    }

    public void put(String jobName, String datasetUrn, CommitSequence commitSequence) throws IOException {
        if (this.exists(jobName, datasetUrn = FsCommitSequenceStore.sanitizeDatasetUrn(datasetUrn))) {
            throw new IOException(String.format("CommitSequence already exists for job %s, dataset %s", jobName, datasetUrn));
        }
        Path jobPath = new Path(this.rootPath, jobName);
        this.fs.mkdirs(jobPath);
        Path datasetPath = new Path(jobPath, datasetUrn);
        try (FSDataOutputStream dos = this.fs.create(datasetPath);){
            dos.writeBytes(GSON.toJson((Object)commitSequence));
        }
    }

    public Collection<String> get(String jobName) throws IOException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Path jobPath = new Path(this.rootPath, jobName);
        if (this.fs.exists(jobPath)) {
            for (FileStatus status : this.fs.listStatus(jobPath, (PathFilter)new HiddenFilter())) {
                builder.add((Object)status.getPath().getName());
            }
        }
        return builder.build();
    }

    public Optional<CommitSequence> get(String jobName, String datasetUrn) throws IOException {
        if (!this.exists(jobName, datasetUrn)) {
            return Optional.absent();
        }
        Path datasetPath = new Path(new Path(this.rootPath, jobName), FsCommitSequenceStore.sanitizeDatasetUrn(datasetUrn));
        try (FSDataInputStream is = this.fs.open(datasetPath);){
            Optional optional = Optional.of((Object)GSON.fromJson(IOUtils.toString((InputStream)is, (Charset)ConfigurationKeys.DEFAULT_CHARSET_ENCODING), CommitSequence.class));
            return optional;
        }
    }

    private static String sanitizeDatasetUrn(String datasetUrn) {
        return Strings.isNullOrEmpty((String)datasetUrn) ? DEFAULT_DATASET_URN : HadoopUtils.sanitizePath((String)datasetUrn, (String)"_");
    }
}

