/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.plugins;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.gobblin.runtime.api.GobblinInstancePluginFactory;
import org.apache.gobblin.util.ClassAliasResolver;

public class GobblinInstancePluginUtils {
    private static final ClassAliasResolver<GobblinInstancePluginFactory> RESOLVER = new ClassAliasResolver(GobblinInstancePluginFactory.class);
    public static final String PLUGINS_KEY = "gobblin.instancepluginAliases";

    public static Collection<GobblinInstancePluginFactory> instantiatePluginsFromSysConfig(Config config) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String pluginsStr = config.getString(PLUGINS_KEY);
        ArrayList plugins = Lists.newArrayList();
        for (String pluginName : Splitter.on((String)",").split((CharSequence)pluginsStr)) {
            plugins.add(GobblinInstancePluginUtils.instantiatePluginByAlias(pluginName));
        }
        return plugins;
    }

    public static GobblinInstancePluginFactory instantiatePluginByAlias(String alias) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (GobblinInstancePluginFactory)RESOLVER.resolveClass(alias).newInstance();
    }
}

