/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.base.Joiner;
import java.io.CharArrayWriter;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hive.service.cli.operation.OperationLog;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class LogDivertAppender
extends WriterAppender {
    private static final Logger LOG = Logger.getLogger((String)LogDivertAppender.class.getName());
    private final OperationManager operationManager;
    private final CharArrayWriter writer = new CharArrayWriter();

    public LogDivertAppender(Layout layout, OperationManager operationManager, boolean isVerbose) {
        this.setLayout(layout);
        this.setWriter(this.writer);
        this.setName("LogDivertAppender");
        this.operationManager = operationManager;
        if (isVerbose) {
            String[] exclLoggerNames = new String[]{LOG.getName(), OperationLog.class.getName(), OperationManager.class.getName()};
            this.addFilter(new NameFilter(true, exclLoggerNames));
        } else {
            String[] inclLoggerNames = new String[]{"org.apache.hadoop.mapreduce.JobSubmitter", "org.apache.hadoop.mapreduce.Job", "SessionState", Task.class.getName()};
            this.addFilter(new NameFilter(false, inclLoggerNames));
        }
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        String logOutput = this.writer.toString();
        this.writer.reset();
        OperationLog log = this.operationManager.getOperationLogByThread();
        if (log == null) {
            LOG.debug((Object)(" ---+++=== Dropped log event from thread " + event.getThreadName()));
            return;
        }
        log.writeOperationLog(logOutput);
    }

    private static class NameFilter
    extends Filter {
        private final Pattern namePattern;
        private final boolean excludeMatches;

        public NameFilter(boolean isExclusionFilter, String[] loggerNames) {
            this.excludeMatches = isExclusionFilter;
            String matchRegex = Joiner.on((String)"|").join((Object[])loggerNames);
            this.namePattern = Pattern.compile(matchRegex);
        }

        public int decide(LoggingEvent ev) {
            boolean isMatch = this.namePattern.matcher(ev.getLoggerName()).matches();
            if (this.excludeMatches == isMatch) {
                return -1;
            }
            return 0;
        }
    }
}

