/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.Prioritizable;
import com.linkedin.parseq.internal.PrioritizableRunnable;
import com.linkedin.parseq.internal.UncaughtExceptionHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class SerialExecutor {
    private final Executor _executor;
    private final UncaughtExceptionHandler _uncaughtExecutionHandler;
    private final ExecutorLoop _executorLoop = new ExecutorLoop();
    private final TaskQueue<PrioritizableRunnable> _queue;
    private final AtomicInteger _pendingCount = new AtomicInteger();
    private final DeactivationListener _deactivationListener;

    public SerialExecutor(Executor executor, UncaughtExceptionHandler uncaughtExecutionHandler, DeactivationListener deactivationListener, TaskQueue<PrioritizableRunnable> taskQueue) {
        ArgumentUtil.requireNotNull(executor, "executor");
        ArgumentUtil.requireNotNull(uncaughtExecutionHandler, "uncaughtExecutionHandler");
        ArgumentUtil.requireNotNull(deactivationListener, "deactivationListener");
        this._executor = executor;
        this._uncaughtExecutionHandler = uncaughtExecutionHandler;
        this._queue = taskQueue;
        this._deactivationListener = deactivationListener;
    }

    public void execute(PrioritizableRunnable runnable) {
        this._queue.add(runnable);
        if (this._pendingCount.getAndIncrement() == 0) {
            this.tryExecuteLoop();
        }
    }

    private void tryExecuteLoop() {
        try {
            this._executor.execute(this._executorLoop);
        }
        catch (Throwable t) {
            this._uncaughtExecutionHandler.uncaughtException(t);
        }
    }

    static interface DeactivationListener {
        public void deactivated();
    }

    public static interface TaskQueue<T extends Prioritizable> {
        public void add(T var1);

        public T poll();
    }

    private class ExecutorLoop
    implements Runnable {
        private ExecutorLoop() {
        }

        @Override
        public void run() {
            Runnable runnable = (Runnable)SerialExecutor.this._queue.poll();
            try {
                runnable.run();
                if (SerialExecutor.this._pendingCount.get() == 1) {
                    SerialExecutor.this._deactivationListener.deactivated();
                }
            }
            catch (Throwable t) {
                SerialExecutor.this._uncaughtExecutionHandler.uncaughtException(t);
            }
            finally {
                if (SerialExecutor.this._pendingCount.decrementAndGet() > 0) {
                    SerialExecutor.this.tryExecuteLoop();
                }
            }
        }
    }
}

