/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.element;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.element.SimpleDataElement;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDataElement
implements DataElement {
    @Override
    public Object getChild(Object childName) {
        Object value = this.getValue();
        Class<?> valueClass = value.getClass();
        if (valueClass == DataList.class && childName.getClass() == Integer.class) {
            int index = (Integer)childName;
            DataList list = (DataList)value;
            if (index >= 0 && index < list.size()) {
                return list.get(index);
            }
        } else if (valueClass == DataMap.class && childName.getClass() == String.class) {
            String name = (String)childName;
            DataMap map = (DataMap)value;
            return map.get(name);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.path(builder, SEPARATOR).append(":").append(this.getValue());
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DataElement other = (DataElement)obj;
        return this.getValue() == other.getValue() && this.getName() == other.getName() && this.getSchema() == other.getSchema() && this.getParent() == other.getParent() && this.level() == other.level();
    }

    @Override
    public Object[] path() {
        int index = this.level();
        Object[] path = new Object[index];
        this.pathInternal(index, path);
        return path;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getValue().hashCode();
        result = result * 31 + this.getName().hashCode();
        result = result * 31 + this.getSchema().hashCode();
        result = result * 31 + this.getParent().hashCode();
        result = result * 31 + this.level();
        return result;
    }

    @Override
    public Object[] path(Object ... appends) {
        int index = this.level();
        Object[] path = new Object[index + appends.length];
        System.arraycopy(appends, 0, path, index, appends.length);
        this.pathInternal(index, path);
        return path;
    }

    private final void pathInternal(int index, Object[] path) {
        DataElement element = this;
        while (index > 0) {
            path[--index] = element.getName();
            element = element.getParent();
        }
    }

    @Override
    public void pathAsList(List<Object> path) {
        path.clear();
        DataElement element = this;
        for (int level = this.level(); level > 0; --level) {
            path.add(element.getName());
            element = element.getParent();
        }
        Collections.reverse(path);
    }

    @Override
    public String pathAsString(Character separator) {
        return this.path(new StringBuilder(), separator).toString();
    }

    @Override
    public String pathAsString() {
        return this.pathAsString(SEPARATOR);
    }

    @Override
    public DataElement copyChain() {
        int index = this.level();
        DataElement[] elements = new DataElement[index + 1];
        for (DataElement element = this; element != null; element = element.getParent()) {
            elements[index] = element;
            --index;
        }
        SimpleDataElement copy = null;
        for (DataElement source : elements) {
            copy = new SimpleDataElement(source.getValue(), source.getName(), source.getSchema(), copy);
        }
        return copy;
    }

    private StringBuilder path(StringBuilder builder, Character separator) {
        DataElement element = this;
        while (element.getParent() != null) {
            builder.insert(0, separator);
            builder.insert(1, element.getName());
            element = element.getParent();
        }
        return builder;
    }
}

