/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.compatibility;

import com.linkedin.data.message.MessageList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.compatibility.CompatibilityMessage;
import com.linkedin.data.schema.compatibility.CompatibilityOptions;
import com.linkedin.data.schema.compatibility.CompatibilityResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CompatibilityChecker {
    private final ArrayDeque<String> _path = new ArrayDeque();
    private final HashSet<Checked> _checked = new HashSet();
    private Result _result;
    private CompatibilityOptions _options;

    public static CompatibilityResult checkCompatibility(DataSchema older, DataSchema newer, CompatibilityOptions options) {
        CompatibilityChecker checker = new CompatibilityChecker();
        checker.run(older, newer, options);
        return checker._result;
    }

    private CompatibilityChecker() {
    }

    private CompatibilityResult run(DataSchema older, DataSchema newer, CompatibilityOptions options) {
        this._path.clear();
        this._checked.clear();
        this._options = options;
        this._result = new Result();
        this.check(older, newer);
        return this._result;
    }

    private void check(DataSchema older, DataSchema newer) {
        Checked toCheck = new Checked(older, newer);
        if (this._checked.contains(toCheck)) {
            return;
        }
        this._checked.add(toCheck);
        if (older == newer) {
            return;
        }
        int pathCount = 1;
        if (this._options.getMode() == CompatibilityOptions.Mode.DATA) {
            older = older.getDereferencedDataSchema();
            while (newer.getType() == DataSchema.Type.TYPEREF) {
                TyperefDataSchema typerefDataSchema = (TyperefDataSchema)newer;
                this._path.addLast(typerefDataSchema.getFullName());
                this._path.addLast("ref");
                ++pathCount;
                newer = typerefDataSchema.getRef();
            }
        }
        if (newer.getType() == DataSchema.Type.TYPEREF) {
            this._path.addLast(((TyperefDataSchema)newer).getFullName());
        } else {
            this._path.addLast(newer.getUnionMemberKey());
        }
        switch (newer.getType()) {
            case TYPEREF: {
                if (!this.isSameType(older, newer)) break;
                this.checkTyperef((TyperefDataSchema)older, (TyperefDataSchema)newer);
                break;
            }
            case RECORD: {
                if (!this.isSameType(older, newer)) break;
                this.checkRecord((RecordDataSchema)older, (RecordDataSchema)newer);
                break;
            }
            case ARRAY: {
                if (!this.isSameType(older, newer)) break;
                this.checkArray((ArrayDataSchema)older, (ArrayDataSchema)newer);
                break;
            }
            case MAP: {
                if (!this.isSameType(older, newer)) break;
                this.checkMap((MapDataSchema)older, (MapDataSchema)newer);
                break;
            }
            case ENUM: {
                if (!this.isSameType(older, newer)) break;
                this.checkEnum((EnumDataSchema)older, (EnumDataSchema)newer);
                break;
            }
            case FIXED: {
                if (!this.isSameType(older, newer)) break;
                this.checkFixed((FixedDataSchema)older, (FixedDataSchema)newer);
                break;
            }
            case UNION: {
                if (!this.isSameType(older, newer)) break;
                this.checkUnion((UnionDataSchema)older, (UnionDataSchema)newer);
                break;
            }
            default: {
                if (newer instanceof PrimitiveDataSchema) {
                    this.checkPrimitive(older, newer);
                    break;
                }
                throw new IllegalStateException("Unknown schema type " + (Object)((Object)newer.getType()) + ", checking old schema " + older + ", new schema " + newer);
            }
        }
        while (pathCount > 0) {
            this._path.removeLast();
            --pathCount;
        }
    }

    private void appendTypeChangedMessage(DataSchema.Type olderType, DataSchema.Type newerType) {
        this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_AND_OLD_READERS, "schema type changed from %s to %s", olderType.toString().toLowerCase(), newerType.toString().toLowerCase());
    }

    private boolean isSameType(DataSchema.Type olderType, DataSchema.Type newerType) {
        boolean isSameType;
        boolean bl = isSameType = olderType == newerType;
        if (!isSameType) {
            this.appendTypeChangedMessage(olderType, newerType);
        }
        return isSameType;
    }

    private boolean isSameType(DataSchema older, DataSchema newer) {
        DataSchema.Type olderType = older.getType();
        DataSchema.Type newerType = newer.getType();
        return this.isSameType(olderType, newerType);
    }

    private void checkPrimitive(DataSchema older, DataSchema newer) {
        DataSchema.Type newerType = newer.getType();
        switch (newerType) {
            case LONG: {
                this.checkAllowedOlderTypes(older.getType(), newerType, DataSchema.Type.INT);
                break;
            }
            case FLOAT: {
                this.checkAllowedOlderTypes(older.getType(), newerType, DataSchema.Type.INT, DataSchema.Type.LONG);
                break;
            }
            case DOUBLE: {
                this.checkAllowedOlderTypes(older.getType(), newerType, DataSchema.Type.INT, DataSchema.Type.LONG, DataSchema.Type.FLOAT);
                break;
            }
            default: {
                this.isSameType(older, newer);
            }
        }
    }

    private void checkAllowedOlderTypes(DataSchema.Type olderType, DataSchema.Type newerType, DataSchema.Type ... allowedOlderTypes) {
        if (this._options.isAllowPromotions()) {
            if (olderType != newerType) {
                boolean allowed = false;
                for (DataSchema.Type type : allowedOlderTypes) {
                    if (type != olderType) continue;
                    allowed = true;
                    break;
                }
                if (allowed) {
                    this.appendMessage(CompatibilityMessage.Impact.VALUES_MAY_BE_TRUNCATED_OR_OVERFLOW, "numeric type promoted from %s to %s", olderType.toString().toLowerCase(), newerType.toString().toLowerCase());
                } else {
                    this.appendTypeChangedMessage(olderType, newerType);
                }
            }
        } else {
            this.isSameType(olderType, newerType);
        }
    }

    private static FieldModifier toFieldModifier(RecordDataSchema.Field field) {
        if (field.getOptional()) {
            return FieldModifier.OPTIONAL;
        }
        if (field.getDefault() != null) {
            return FieldModifier.REQUIRED_WITH_DEFAULT;
        }
        return FieldModifier.REQUIRED;
    }

    private void checkRecord(RecordDataSchema older, RecordDataSchema newer) {
        RecordDataSchema.Field olderField;
        String fieldName;
        this.checkName(older, newer);
        ArrayList<RecordDataSchema.Field> commonFields = new ArrayList<RecordDataSchema.Field>(newer.getFields().size());
        CheckerArrayList newerRequiredAdded = new CheckerArrayList();
        CheckerArrayList newerRequiredWithDefaultAdded = new CheckerArrayList();
        CheckerArrayList newerOptionalAdded = new CheckerArrayList();
        CheckerArrayList requiredToOptional = new CheckerArrayList();
        CheckerArrayList requiredWithDefaultToOptional = new CheckerArrayList();
        CheckerArrayList optionalToRequired = new CheckerArrayList();
        CheckerArrayList optionalToRequiredWithDefault = new CheckerArrayList();
        CheckerArrayList newerRequiredRemoved = new CheckerArrayList();
        CheckerArrayList newerOptionalRemoved = new CheckerArrayList();
        CheckerArrayList requiredWithDefaultToRequired = new CheckerArrayList();
        CheckerArrayList requiredToRequiredWithDefault = new CheckerArrayList();
        for (RecordDataSchema.Field newerField : newer.getFields()) {
            fieldName = newerField.getName();
            olderField = older.getField(fieldName);
            FieldModifier newerFieldModifier = CompatibilityChecker.toFieldModifier(newerField);
            if (olderField == null) {
                if (newerFieldModifier == FieldModifier.OPTIONAL) {
                    newerOptionalAdded.add(fieldName);
                    continue;
                }
                if (newerFieldModifier == FieldModifier.REQUIRED) {
                    newerRequiredAdded.add(fieldName);
                    continue;
                }
                if (newerFieldModifier != FieldModifier.REQUIRED_WITH_DEFAULT) continue;
                newerRequiredWithDefaultAdded.add(fieldName);
                continue;
            }
            FieldModifier olderFieldModifier = CompatibilityChecker.toFieldModifier(olderField);
            commonFields.add(newerField);
            if (olderFieldModifier == FieldModifier.OPTIONAL && newerFieldModifier == FieldModifier.REQUIRED_WITH_DEFAULT) {
                optionalToRequiredWithDefault.add(fieldName);
                continue;
            }
            if (olderFieldModifier == FieldModifier.OPTIONAL && newerFieldModifier == FieldModifier.REQUIRED) {
                optionalToRequired.add(fieldName);
                continue;
            }
            if (olderFieldModifier == FieldModifier.REQUIRED && newerFieldModifier == FieldModifier.OPTIONAL) {
                requiredToOptional.add(fieldName);
                continue;
            }
            if (olderFieldModifier == FieldModifier.REQUIRED && newerFieldModifier == FieldModifier.REQUIRED_WITH_DEFAULT) {
                requiredToRequiredWithDefault.add(fieldName);
                continue;
            }
            if (olderFieldModifier == FieldModifier.REQUIRED_WITH_DEFAULT && newerFieldModifier == FieldModifier.OPTIONAL) {
                requiredWithDefaultToOptional.add(fieldName);
                continue;
            }
            if (olderFieldModifier != FieldModifier.REQUIRED_WITH_DEFAULT || newerFieldModifier != FieldModifier.REQUIRED) continue;
            requiredWithDefaultToRequired.add(fieldName);
        }
        for (RecordDataSchema.Field olderField2 : older.getFields()) {
            fieldName = olderField2.getName();
            RecordDataSchema.Field newerField = newer.getField(fieldName);
            if (newerField != null) continue;
            (olderField2.getOptional() ? newerOptionalRemoved : newerRequiredRemoved).add(fieldName);
        }
        if (!newerRequiredAdded.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_READER, "new record added required fields %s", newerRequiredAdded);
        }
        if (!newerRequiredWithDefaultAdded.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.OLD_READER_IGNORES_DATA, "new record added required with default fields %s", newerRequiredAdded);
        }
        if (!newerRequiredRemoved.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_OLD_READER, "new record removed required fields %s", newerRequiredRemoved);
        }
        if (!optionalToRequired.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_READER, "new record changed optional fields to required fields %s", optionalToRequired);
        }
        if (!optionalToRequiredWithDefault.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_AND_OLD_READERS, "new record changed optional fields to required fields with defaults %s. This change is compatible for Pegasus but incompatible for Avro, if this record schema is never converted to Avro, this error may safely be ignored.", optionalToRequiredWithDefault);
        }
        if (!requiredToOptional.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_OLD_READER, "new record changed required fields to optional fields %s", requiredToOptional);
        }
        if (!requiredWithDefaultToOptional.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_AND_OLD_READERS, "new record changed required fields with defaults to optional fields %s. This change is compatible for Pegasus but incompatible for Avro, if this record schema is never converted to Avro, this error may safely be ignored.", requiredWithDefaultToOptional);
        }
        if (!newerOptionalAdded.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.OLD_READER_IGNORES_DATA, "new record added optional fields %s", newerOptionalAdded);
        }
        if (!newerOptionalRemoved.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_AND_OLD_READERS, "new record removed optional fields %s. This allows a new field to be added with the same name but different type in the future.", newerOptionalRemoved);
        }
        if (!requiredWithDefaultToRequired.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_READER, "new record removed default from required fields %s", requiredWithDefaultToRequired);
        }
        if (!requiredToRequiredWithDefault.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_OLD_READER, "new record added default to required fields %s", requiredToRequiredWithDefault);
        }
        for (RecordDataSchema.Field newerField : commonFields) {
            fieldName = newerField.getName();
            this._path.addLast(fieldName);
            olderField = older.getField(fieldName);
            assert (olderField != null);
            this.check(olderField.getType(), newerField.getType());
            this._path.removeLast();
        }
    }

    private void computeAddedUnionMembers(UnionDataSchema base, UnionDataSchema changed, List<String> added, List<DataSchema> commonMembers) {
        for (DataSchema member : changed.getTypes()) {
            String unionMemberKey = member.getUnionMemberKey();
            if (!base.contains(unionMemberKey)) {
                added.add(unionMemberKey);
                continue;
            }
            if (commonMembers == null) continue;
            commonMembers.add(member);
        }
    }

    private void checkUnion(UnionDataSchema older, UnionDataSchema newer) {
        CheckerArrayList<DataSchema> commonMembers = new CheckerArrayList<DataSchema>(newer.getTypes().size());
        CheckerArrayList<String> newerAdded = new CheckerArrayList<String>();
        CheckerArrayList<String> olderAdded = new CheckerArrayList<String>();
        this.computeAddedUnionMembers(older, newer, newerAdded, commonMembers);
        this.computeAddedUnionMembers(newer, older, olderAdded, null);
        if (!newerAdded.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_OLD_READER, "new union added members %s", newerAdded);
        }
        if (!olderAdded.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_READER, "new union removed members %s", olderAdded);
        }
        for (DataSchema newerSchema : commonMembers) {
            String memberKey = newerSchema.getUnionMemberKey();
            DataSchema olderSchema = older.getType(memberKey);
            assert (olderSchema != null);
            this.check(olderSchema, newerSchema);
        }
    }

    private void checkEnum(EnumDataSchema older, EnumDataSchema newer) {
        this.checkName(older, newer);
        this._path.addLast("symbols");
        CheckerArrayList newerOnlySymbols = new CheckerArrayList(newer.getSymbols());
        newerOnlySymbols.removeAll(older.getSymbols());
        CheckerArrayList olderOnlySymbols = new CheckerArrayList(older.getSymbols());
        olderOnlySymbols.removeAll(newer.getSymbols());
        if (!newerOnlySymbols.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_OLD_READER, "new enum added symbols %s", newerOnlySymbols);
        }
        if (!olderOnlySymbols.isEmpty()) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_READER, "new enum removed symbols %s", olderOnlySymbols);
        }
        this._path.removeLast();
    }

    private void checkFixed(FixedDataSchema older, FixedDataSchema newer) {
        this.checkName(older, newer);
        this._path.addLast("size");
        int olderSize = older.getSize();
        int newerSize = newer.getSize();
        if (olderSize != newerSize) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_AND_OLD_READERS, "fixed size changed from %d to %d", olderSize, newerSize);
        }
        this._path.removeLast();
    }

    private void checkTyperef(TyperefDataSchema older, TyperefDataSchema newer) {
        this.checkName(older, newer);
        this._path.addLast("ref");
        this.check(older.getDereferencedDataSchema(), newer.getDereferencedDataSchema());
        this._path.removeLast();
    }

    private void checkArray(ArrayDataSchema older, ArrayDataSchema newer) {
        this._path.addLast("items");
        this.check(older.getItems(), newer.getItems());
        this._path.removeLast();
    }

    private void checkMap(MapDataSchema older, MapDataSchema newer) {
        this._path.addLast("values");
        this.check(older.getValues(), newer.getValues());
        this._path.removeLast();
    }

    private void checkName(NamedDataSchema older, NamedDataSchema newer) {
        if (this._options.isCheckNames() && !older.getFullName().equals(newer.getFullName())) {
            this.appendMessage(CompatibilityMessage.Impact.BREAKS_NEW_AND_OLD_READERS, "name changed from %s to %s", older.getFullName(), newer.getFullName());
        }
    }

    private void appendMessage(CompatibilityMessage.Impact impact, String format, Object ... args) {
        CompatibilityMessage message = new CompatibilityMessage(this._path.toArray(), impact, format, args);
        this._result._messages.add(message);
    }

    private static class CheckerArrayList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;

        private CheckerArrayList() {
        }

        private CheckerArrayList(int reserve) {
            super(reserve);
        }

        private CheckerArrayList(Collection<T> c) {
            super(c);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.get(i));
            }
            return sb.toString();
        }
    }

    private static class Result
    implements CompatibilityResult {
        private final MessageList<CompatibilityMessage> _messages = new MessageList();

        private Result() {
        }

        @Override
        public Collection<CompatibilityMessage> getMessages() {
            return this._messages;
        }

        @Override
        public boolean isError() {
            return this._messages.isError();
        }
    }

    private static enum FieldModifier {
        OPTIONAL,
        REQUIRED,
        REQUIRED_WITH_DEFAULT;

    }

    private static class Checked {
        private final DataSchema _older;
        private final DataSchema _newer;

        private Checked(DataSchema older, DataSchema newer) {
            this._older = older;
            this._newer = newer;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            Checked other = (Checked)o;
            return other._older == this._older && other._newer == this._newer;
        }

        public int hashCode() {
            return this._older.hashCode() + this._newer.hashCode();
        }
    }
}

