/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.util;

import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

class Conversions {
    static final String UNEXPECTED_IOEXCEPTION = "Unexpected IOException\n";
    static final String WRONG_NUMBER_OF_SCHEMA_LEFT = "No or too many resulting schemas, should have one resulting schema\n";

    Conversions() {
    }

    public static DataMap dataSchemaToDataMap(NamedDataSchema schema) {
        String inputSchemaAsString = schema.toString();
        try {
            JacksonDataCodec codec = new JacksonDataCodec();
            DataMap schemaAsDataMap = codec.stringToMap(inputSchemaAsString);
            return schemaAsDataMap;
        }
        catch (IOException e) {
            throw new IllegalStateException(UNEXPECTED_IOEXCEPTION + inputSchemaAsString, e);
        }
    }

    public static DataSchema dataMapToDataSchema(DataMap map, PegasusSchemaParser parser) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JacksonDataCodec codec = new JacksonDataCodec();
        try {
            codec.writeMap(map, outputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(UNEXPECTED_IOEXCEPTION + map, e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        parser.parse(inputStream);
        List<DataSchema> topLevelDataSchemas = parser.topLevelDataSchemas();
        assert (topLevelDataSchemas.size() <= 1);
        if (parser.hasError()) {
            return null;
        }
        if (topLevelDataSchemas.size() != 1) {
            throw new IllegalStateException(WRONG_NUMBER_OF_SCHEMA_LEFT + topLevelDataSchemas);
        }
        return topLevelDataSchemas.get(0);
    }
}

