/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.validator;

import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.message.Message;
import com.linkedin.data.schema.validator.AbstractValidator;
import com.linkedin.data.schema.validator.ValidatorContext;
import java.util.regex.Pattern;

public class RegexValidator
extends AbstractValidator {
    public static final String REGEX = "regex";
    private final String _regex;
    private final Pattern _pattern;

    public RegexValidator(DataMap config) {
        super(config);
        this._regex = config.getString(REGEX);
        if (this._regex == null) {
            throw new IllegalArgumentException("\"regex\" is required");
        }
        this._pattern = Pattern.compile(this._regex);
    }

    @Override
    public void validate(ValidatorContext ctx) {
        DataElement element = ctx.dataElement();
        Object value = element.getValue();
        String str = String.valueOf(value);
        boolean matches = this._pattern.matcher(str).matches();
        if (!matches) {
            ctx.addResult(new Message(element.path(), "\"%1$s\" does not match %2$s", str, this._regex));
        }
    }
}

