/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataObjectToObjectCache;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.TemplateOutputCastException;

public abstract class RecordTemplate
implements DataTemplate<DataMap> {
    private DataMap _map;
    private final RecordDataSchema _schema;
    private DataObjectToObjectCache<Object> _cache;

    protected RecordTemplate(DataMap map, RecordDataSchema schema) {
        this._map = map;
        this._schema = schema;
    }

    @Override
    public RecordDataSchema schema() {
        return this._schema;
    }

    @Override
    public DataMap data() {
        return this._map;
    }

    public RecordTemplate clone() throws CloneNotSupportedException {
        RecordTemplate clone = (RecordTemplate)super.clone();
        clone._map = clone._map.clone();
        clone._cache = clone._cache != null ? clone._cache.clone() : null;
        return clone;
    }

    public RecordTemplate copy() throws CloneNotSupportedException {
        RecordTemplate copy = (RecordTemplate)super.clone();
        copy._map = this._map.copy();
        copy._cache = null;
        return copy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof RecordTemplate) {
            return ((RecordTemplate)object)._map.equals(this._map);
        }
        return false;
    }

    public int hashCode() {
        return this._map.hashCode();
    }

    public String toString() {
        return this._map.toString();
    }

    protected boolean contains(RecordDataSchema.Field field) {
        return this._map.containsKey(field.getName());
    }

    protected boolean remove(RecordDataSchema.Field field) {
        return this._map.remove(field.getName()) != null;
    }

    protected <T> void putDirect(RecordDataSchema.Field field, Class<T> valueClass, Class<?> dataClass, T object, SetMode mode) throws ClassCastException {
        if (this.checkPutNullValue(field, object, mode)) {
            this._map.put(field.getName(), DataTemplateUtil.coerceInput(object, valueClass, dataClass));
        }
    }

    protected <T> void putCustomType(RecordDataSchema.Field field, Class<T> valueClass, Class<?> dataClass, T object, SetMode mode) throws ClassCastException {
        if (this.checkPutNullValue(field, object, mode)) {
            Object coerced = DataTemplateUtil.coerceInput(object, valueClass, dataClass);
            this._map.put(field.getName(), coerced);
            this.getCache().put(coerced, object);
        }
    }

    protected <T> void putDirect(RecordDataSchema.Field field, Class<T> valueClass, T object, SetMode mode) throws ClassCastException {
        this.putDirect(field, valueClass, valueClass.isEnum() ? String.class : valueClass, object, mode);
    }

    protected <T> void putDirect(RecordDataSchema.Field field, Class<T> valueClass, T object) throws ClassCastException {
        this.putDirect(field, valueClass, object, SetMode.DISALLOW_NULL);
    }

    protected <T extends DataTemplate<?>> void putWrapped(RecordDataSchema.Field field, Class<T> valueClass, T object, SetMode mode) throws ClassCastException {
        if (this.checkPutNullValue(field, object, mode)) {
            if (object.getClass() == valueClass) {
                this._map.put(field.getName(), object.data());
                this.getCache().put(object.data(), object);
            } else {
                throw new ClassCastException("Input " + object + " should be a " + valueClass.getName());
            }
        }
    }

    protected <T extends DataTemplate<?>> void putWrapped(RecordDataSchema.Field field, Class<T> valueClass, T object) throws ClassCastException {
        this.putWrapped(field, valueClass, object, SetMode.DISALLOW_NULL);
    }

    protected <T> T obtainDirect(RecordDataSchema.Field field, Class<T> valueClass, GetMode mode) throws RequiredFieldNotPresentException, TemplateOutputCastException {
        Object found = this.obtainValueOrDefault(field, mode);
        if (found == null) {
            return null;
        }
        return DataTemplateUtil.coerceOutput(found, valueClass);
    }

    protected <T> T obtainCustomType(RecordDataSchema.Field field, Class<T> valueClass, GetMode mode) throws RequiredFieldNotPresentException, TemplateOutputCastException {
        T coerced;
        Object found = this.obtainValueOrDefault(field, mode);
        if (found == null) {
            return null;
        }
        Object customTypeValue = this.getCache().get(found);
        if (customTypeValue != null && customTypeValue.getClass() == valueClass) {
            coerced = valueClass.cast(customTypeValue);
        } else {
            coerced = DataTemplateUtil.coerceOutput(found, valueClass);
            this.getCache().put(found, coerced);
        }
        return coerced;
    }

    protected <T extends DataTemplate<?>> T obtainWrapped(RecordDataSchema.Field field, Class<T> valueClass, GetMode mode) throws RequiredFieldNotPresentException, TemplateOutputCastException {
        DataTemplate wrapped;
        Object found = this.obtainValueOrDefault(field, mode);
        if (found == null) {
            wrapped = null;
        } else {
            DataTemplate template = (DataTemplate)this.getCache().get(found);
            if (template != null && template.data() == found) {
                wrapped = (DataTemplate)valueClass.cast(template);
            } else {
                wrapped = (DataTemplate)DataTemplateUtil.wrap(found, field.getType(), valueClass);
                this.getCache().put(found, wrapped);
            }
        }
        return (T)wrapped;
    }

    private Object obtainValueOrDefault(RecordDataSchema.Field field, GetMode mode) throws RequiredFieldNotPresentException {
        Object defaultValue = field.getDefault();
        String fieldName = field.getName();
        Object found = this._map.get(field.getName());
        if (found == null && mode != GetMode.NULL) {
            if (defaultValue != null) {
                found = defaultValue;
            } else if (!field.getOptional() && mode == GetMode.STRICT) {
                throw new RequiredFieldNotPresentException(fieldName);
            }
        }
        return found;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPutNullValue(RecordDataSchema.Field field, Object object, SetMode mode) {
        if (object != null) return true;
        boolean doPut = false;
        switch (mode) {
            case IGNORE_NULL: {
                return doPut;
            }
            case REMOVE_IF_NULL: {
                this._map.remove(field.getName());
                return false;
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (!field.getOptional()) throw new IllegalArgumentException("Cannot remove mandatory field " + field.getName() + " of " + this._schema.getFullName());
                this._map.remove(field.getName());
                return false;
            }
            case DISALLOW_NULL: {
                throw new NullPointerException("Cannot set field " + field.getName() + " of " + this._schema.getFullName() + " to null");
            }
            default: {
                throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
            }
        }
    }

    private DataObjectToObjectCache<Object> getCache() {
        if (this._cache == null) {
            this._cache = new DataObjectToObjectCache();
        }
        return this._cache;
    }
}

