/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.util.Date;
import org.datanucleus.query.evaluator.memory.AggregateExpression;

public class DateAggregateExpression
extends AggregateExpression {
    Date value;

    public DateAggregateExpression(Date value) {
        this.value = value;
    }

    @Override
    public Object add(Object obj) {
        if (obj instanceof Date) {
            long currentVal = this.value.getTime();
            long inputVal = ((Date)obj).getTime();
            return new Date(currentVal + inputVal);
        }
        return super.add(obj);
    }

    @Override
    public Object sub(Object obj) {
        if (obj instanceof Date) {
            long currentVal = this.value.getTime();
            long inputVal = ((Date)obj).getTime();
            return new Date(currentVal - inputVal);
        }
        return super.sub(obj);
    }

    @Override
    public Boolean gt(Object obj) {
        if (obj instanceof Date) {
            long inputVal;
            long currentVal = this.value.getTime();
            return currentVal > (inputVal = ((Date)obj).getTime()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.gt(obj);
    }

    @Override
    public Boolean lt(Object obj) {
        if (obj instanceof Date) {
            long inputVal;
            long currentVal = this.value.getTime();
            return currentVal < (inputVal = ((Date)obj).getTime()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.lt(obj);
    }

    @Override
    public Boolean eq(Object obj) {
        if (obj instanceof Date) {
            long inputVal;
            long currentVal = this.value.getTime();
            return currentVal == (inputVal = ((Date)obj).getTime()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.eq(obj);
    }
}

