/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class AnnotationProcessorUtils {
    private static Set<String> LIST_CLASSNAMES = null;
    private static Set<String> SET_CLASSNAMES = null;
    private static Set<String> MAP_CLASSNAMES = null;
    private static Set<String> COLLECTION_CLASSNAMES = null;

    public static TypeCategory getTypeCategoryForTypeMirror(String typeName) {
        if (COLLECTION_CLASSNAMES.contains(typeName)) {
            return TypeCategory.COLLECTION;
        }
        if (SET_CLASSNAMES.contains(typeName)) {
            return TypeCategory.SET;
        }
        if (LIST_CLASSNAMES.contains(typeName)) {
            return TypeCategory.LIST;
        }
        if (MAP_CLASSNAMES.contains(typeName)) {
            return TypeCategory.MAP;
        }
        return TypeCategory.ATTRIBUTE;
    }

    public static List<? extends Element> getFieldMembers(TypeElement el) {
        List<? extends Element> members = el.getEnclosedElements();
        ArrayList<Element> fieldMembers = new ArrayList<Element>();
        for (Element element : members) {
            if (element.getKind() != ElementKind.FIELD) continue;
            fieldMembers.add(element);
        }
        return fieldMembers;
    }

    public static List<? extends Element> getPropertyMembers(TypeElement el) {
        List<? extends Element> members = el.getEnclosedElements();
        ArrayList<Element> propertyMembers = new ArrayList<Element>();
        for (Element element : members) {
            ExecutableElement method;
            if (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter(method = (ExecutableElement)element) && !AnnotationProcessorUtils.isJavaBeanSetter(method)) continue;
            propertyMembers.add(element);
        }
        return propertyMembers;
    }

    public static boolean isJavaBeanGetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (method.getKind() == ElementKind.METHOD && method.getParameters().isEmpty()) {
            if (AnnotationProcessorUtils.returnsBoolean(method) && methodName.startsWith("is")) {
                return true;
            }
            if (methodName.startsWith("get") && !AnnotationProcessorUtils.returnsVoid(method)) {
                return true;
            }
        }
        return false;
    }

    public static String getMemberName(Element el) {
        ExecutableElement method;
        if (el.getKind() == ElementKind.FIELD) {
            return el.toString();
        }
        if (el.getKind() == ElementKind.METHOD && (AnnotationProcessorUtils.isJavaBeanGetter(method = (ExecutableElement)el) || AnnotationProcessorUtils.isJavaBeanSetter(method))) {
            String name = method.getSimpleName().toString();
            name = name.startsWith("is") ? name.substring(2) : name.substring(3);
            return Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return null;
    }

    public static boolean isJavaBeanSetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return method.getKind() == ElementKind.METHOD && methodName.startsWith("set") && method.getParameters().isEmpty() && !AnnotationProcessorUtils.returnsVoid(method);
    }

    public static boolean isMethod(Element elem) {
        return elem != null && ExecutableElement.class.isInstance(elem) && elem.getKind() == ElementKind.METHOD;
    }

    public static TypeMirror getDeclaredType(Element elem) {
        if (elem.getKind() == ElementKind.FIELD) {
            return elem.asType();
        }
        if (elem.getKind() == ElementKind.METHOD) {
            return ((ExecutableElement)elem).getReturnType();
        }
        throw new IllegalArgumentException("Unable to get type for " + elem);
    }

    public static Object getValueForAnnotationAttribute(Element elem, Class annotCls, String attribute) {
        List<? extends AnnotationMirror> anns = elem.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : anns) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotCls.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                ExecutableElement ex = entry.getKey();
                if (!ex.getSimpleName().toString().equals(attribute)) continue;
                return entry.getValue().getValue();
            }
        }
        return null;
    }

    public static boolean returnsVoid(ExecutableElement method) {
        TypeMirror type = method.getReturnType();
        return type != null && type.getKind() == TypeKind.VOID;
    }

    public static boolean returnsBoolean(ExecutableElement method) {
        TypeMirror type = method.getReturnType();
        return type != null && (type.getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(type.toString()));
    }

    public static boolean typeIsPrimitive(TypeMirror type) {
        TypeKind kind = type.getKind();
        return kind == TypeKind.BOOLEAN || kind == TypeKind.BYTE || kind == TypeKind.CHAR || kind == TypeKind.DOUBLE || kind == TypeKind.FLOAT || kind == TypeKind.INT || kind == TypeKind.LONG || kind == TypeKind.SHORT;
    }

    public static String getDeclaredTypeName(ProcessingEnvironment processingEnv, TypeMirror type, boolean box) {
        if (type == null || type.getKind() == TypeKind.NULL || type.getKind() == TypeKind.WILDCARD) {
            return "java.lang.Object";
        }
        if (type.getKind() == TypeKind.ARRAY) {
            TypeMirror comp = ((ArrayType)type).getComponentType();
            return AnnotationProcessorUtils.getDeclaredTypeName(processingEnv, comp, false);
        }
        if (box && AnnotationProcessorUtils.typeIsPrimitive(type)) {
            type = processingEnv.getTypeUtils().boxedClass((PrimitiveType)type).asType();
        }
        if (AnnotationProcessorUtils.typeIsPrimitive(type)) {
            return ((PrimitiveType)type).toString();
        }
        return processingEnv.getTypeUtils().asElement(type).toString();
    }

    static {
        LIST_CLASSNAMES = new HashSet<String>();
        LIST_CLASSNAMES.add("java.util.List");
        LIST_CLASSNAMES.add("java.util.ArrayList");
        LIST_CLASSNAMES.add("java.util.AbstractList");
        LIST_CLASSNAMES.add("java.util.Stack");
        LIST_CLASSNAMES.add("java.util.Vector");
        LIST_CLASSNAMES.add("java.util.LinkedList");
        SET_CLASSNAMES = new HashSet<String>();
        SET_CLASSNAMES.add("java.util.Set");
        SET_CLASSNAMES.add("java.util.HashSet");
        SET_CLASSNAMES.add("java.util.AbstractSet");
        SET_CLASSNAMES.add("java.util.LinkedHashSet");
        SET_CLASSNAMES.add("java.util.TreeSet");
        SET_CLASSNAMES.add("java.util.SortedSet");
        MAP_CLASSNAMES = new HashSet<String>();
        MAP_CLASSNAMES.add("java.util.Map");
        MAP_CLASSNAMES.add("java.util.HashMap");
        MAP_CLASSNAMES.add("java.util.AbstractMap");
        MAP_CLASSNAMES.add("java.util.Hashtable");
        MAP_CLASSNAMES.add("java.util.LinkedHashMap");
        SET_CLASSNAMES.add("java.util.TreeMap");
        MAP_CLASSNAMES.add("java.util.SortedMap");
        MAP_CLASSNAMES.add("java.util.Properties");
        COLLECTION_CLASSNAMES = new HashSet<String>();
        COLLECTION_CLASSNAMES.add("java.util.Collection");
        COLLECTION_CLASSNAMES.add("java.util.AbstractCollection");
        COLLECTION_CLASSNAMES.add("java.util.Queue");
        COLLECTION_CLASSNAMES.add("java.util.PriorityQueue");
    }

    public static enum TypeCategory {
        COLLECTION("CollectionAttribute"),
        SET("SetAttribute"),
        LIST("ListAttribute"),
        MAP("MapAttribute"),
        ATTRIBUTE("SingularAttribute");

        private String type;

        private TypeCategory(String type) {
            this.type = type;
        }

        public String getTypeName() {
            return this.type;
        }
    }
}

