/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.flow;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.runtime.api.FlowEdge;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.TopologySpec;
import org.apache.gobblin.runtime.job_catalog.FSJobCatalog;
import org.apache.gobblin.runtime.job_spec.ResolvedJobSpec;
import org.apache.gobblin.runtime.spec_executorInstance.BaseServiceNodeImpl;
import org.apache.gobblin.runtime.spec_executorInstance.InMemorySpecExecutor;
import org.apache.gobblin.service.modules.flow.BaseFlowToJobSpecCompiler;
import org.apache.gobblin.service.modules.flow.FlowEdgeProps;
import org.apache.gobblin.service.modules.flow.LoadBasedFlowEdgeImpl;
import org.apache.gobblin.service.modules.policy.ServicePolicy;
import org.apache.gobblin.service.modules.utils.FindPathUtils;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHopsFlowToJobSpecCompiler
extends BaseFlowToJobSpecCompiler {
    private static final Logger log = LoggerFactory.getLogger(MultiHopsFlowToJobSpecCompiler.class);
    private static final Splitter SPLIT_BY_COMMA = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private DirectedWeightedMultigraph<ServiceNode, FlowEdge> weightedGraph = new DirectedWeightedMultigraph(LoadBasedFlowEdgeImpl.class);
    public ServicePolicy servicePolicy;
    private Optional<String> optionalUserSpecifiedPath;
    private FlowEdgeProps defaultFlowEdgeProps = new FlowEdgeProps();

    public MultiHopsFlowToJobSpecCompiler(Config config) {
        this(config, (Optional<Logger>)Optional.absent(), true);
    }

    public MultiHopsFlowToJobSpecCompiler(Config config, Optional<Logger> log) {
        this(config, log, true);
    }

    public MultiHopsFlowToJobSpecCompiler(Config config, Optional<Logger> log, boolean instrumentationEnabled) {
        super(config, log, instrumentationEnabled);
        String policyClassName = config.hasPath("gobblin.service.servicePolicy") ? config.getString("gobblin.service.servicePolicy") : "static";
        ClassAliasResolver classResolver = new ClassAliasResolver(ServicePolicy.class);
        try {
            this.servicePolicy = (ServicePolicy)classResolver.resolveClass(policyClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error happen when resolving class for :" + policyClassName, e);
        }
        if (config.hasPath("gobblin.service.blockedConnections") && config.getStringList("gobblin.service.blockedConnections").size() > 0) {
            try {
                for (String sourceSinkPair : config.getStringList("gobblin.service.blockedConnections")) {
                    BaseServiceNodeImpl source = new BaseServiceNodeImpl(sourceSinkPair.split(":")[0]);
                    BaseServiceNodeImpl sink = new BaseServiceNodeImpl(sourceSinkPair.split(":")[1]);
                    URI specExecutorURI = new URI(sourceSinkPair.split(":")[2]);
                    this.servicePolicy.addFlowEdge(new LoadBasedFlowEdgeImpl((ServiceNode)source, (ServiceNode)sink, InMemorySpecExecutor.createDummySpecExecutor((URI)specExecutorURI)));
                }
            }
            catch (URISyntaxException e) {
                MultiHopsFlowToJobSpecCompiler.log.warn("Constructing of FlowEdge in ServicePolicy Failed");
            }
        }
        if (config.hasPath("gobblin.service.blockedNodes") && StringUtils.isNotBlank((CharSequence)config.getString("gobblin.service.blockedNodes"))) {
            for (String blacklistedNode : SPLIT_BY_COMMA.splitToList((CharSequence)config.getString("gobblin.service.blockedNodes"))) {
                this.servicePolicy.addServiceNode((ServiceNode)new BaseServiceNodeImpl(blacklistedNode));
            }
        }
        this.optionalUserSpecifiedPath = config.hasPath("gobblin.service.fullDataPath") && StringUtils.isNotBlank((CharSequence)config.getString("gobblin.service.fullDataPath")) ? Optional.of((Object)config.getString("gobblin.service.fullDataPath")) : Optional.absent();
    }

    @Override
    public Map<Spec, SpecExecutor> compileFlow(Spec spec) {
        LinkedHashMap specExecutorInstanceMap = Maps.newLinkedHashMap();
        this.findPath(specExecutorInstanceMap, spec);
        return specExecutorInstanceMap;
    }

    private void inMemoryWeightGraphGenerator() {
        for (TopologySpec topologySpec : this.topologySpecMap.values()) {
            this.weightGraphGenerateHelper(topologySpec);
        }
        this.servicePolicy.populateBlackListedEdges(this.weightedGraph);
        if (this.servicePolicy.getBlacklistedEdges().size() > 0) {
            for (FlowEdge toDeletedEdge : this.servicePolicy.getBlacklistedEdges()) {
                this.weightedGraph.removeEdge((Object)toDeletedEdge);
            }
        }
    }

    private void findPath(Map<Spec, SpecExecutor> specExecutorInstanceMap, Spec spec) {
        this.inMemoryWeightGraphGenerator();
        FlowSpec flowSpec = (FlowSpec)spec;
        if (this.optionalUserSpecifiedPath.isPresent()) {
            log.info("Starting to evaluate user's specified path ... ");
            if (this.userSpecifiedPathVerificator(specExecutorInstanceMap, flowSpec)) {
                log.info("User specified path[ " + (String)this.optionalUserSpecifiedPath.get() + "] successfully verified.");
                return;
            }
            log.error("Will not execute user specified path[ " + (String)this.optionalUserSpecifiedPath.get() + "]");
            log.info("Start to execute FlowCompiler's algorithm for valid data movement path");
        }
        BaseServiceNodeImpl sourceNode = new BaseServiceNodeImpl(flowSpec.getConfig().getString("gobblin.flow.sourceIdentifier"));
        BaseServiceNodeImpl targetNode = new BaseServiceNodeImpl(flowSpec.getConfig().getString("gobblin.flow.destinationIdentifier"));
        List<FlowEdge> resultEdgePath = FindPathUtils.dijkstraBasedPathFindingHelper((ServiceNode)sourceNode, (ServiceNode)targetNode, this.weightedGraph);
        for (int i = 0; i < resultEdgePath.size(); ++i) {
            FlowEdge tmpFlowEdge = resultEdgePath.get(i);
            ServiceNode edgeSrcNode = ((LoadBasedFlowEdgeImpl)tmpFlowEdge).getSourceNode();
            ServiceNode edgeTgtNode = ((LoadBasedFlowEdgeImpl)tmpFlowEdge).getTargetNode();
            specExecutorInstanceMap.put((Spec)this.convertHopToJobSpec(edgeSrcNode, edgeTgtNode, flowSpec), ((LoadBasedFlowEdgeImpl)resultEdgePath.get(i)).getSpecExecutorInstance());
        }
    }

    @Override
    protected void populateEdgeTemplateMap() {
        if (this.templateCatalog.isPresent()) {
            for (FlowEdge flowEdge : this.weightedGraph.edgeSet()) {
                this.edgeTemplateMap.put(flowEdge.getEdgeIdentity(), ((FSJobCatalog)this.templateCatalog.get()).getAllTemplates().stream().map(jobTemplate -> jobTemplate.getUri()).collect(Collectors.toList()));
            }
        }
    }

    private boolean userSpecifiedPathVerificator(Map<Spec, SpecExecutor> specExecutorInstanceMap, FlowSpec flowSpec) {
        HashMap<JobSpec, SpecExecutor> tmpSpecExecutorInstanceMap = new HashMap<JobSpec, SpecExecutor>();
        List<String> userSpecfiedPath = Arrays.asList(((String)this.optionalUserSpecifiedPath.get()).split(","));
        for (int i = 0; i < userSpecfiedPath.size() - 1; ++i) {
            BaseServiceNodeImpl sourceNode = new BaseServiceNodeImpl(userSpecfiedPath.get(i));
            BaseServiceNodeImpl targetNode = new BaseServiceNodeImpl(userSpecfiedPath.get(i + 1));
            if (!(this.weightedGraph.containsVertex((Object)sourceNode) && this.weightedGraph.containsVertex((Object)targetNode) && this.weightedGraph.containsEdge((Object)sourceNode, (Object)targetNode))) {
                log.error("User Specified Path is invalid");
                return false;
            }
            tmpSpecExecutorInstanceMap.put(this.convertHopToJobSpec((ServiceNode)sourceNode, (ServiceNode)targetNode, flowSpec), ((LoadBasedFlowEdgeImpl)((Object)this.weightedGraph.getEdge((Object)sourceNode, (Object)targetNode))).getSpecExecutorInstance());
        }
        specExecutorInstanceMap.putAll(tmpSpecExecutorInstanceMap);
        return true;
    }

    private void weightGraphGenerateHelper(TopologySpec topologySpec) {
        try {
            Map capabilities = (Map)topologySpec.getSpecExecutor().getCapabilities().get();
            for (Map.Entry capability : capabilities.entrySet()) {
                LoadBasedFlowEdgeImpl flowEdge;
                BaseServiceNodeImpl sourceNode = new BaseServiceNodeImpl(((ServiceNode)capability.getKey()).getNodeName());
                BaseServiceNodeImpl targetNode = new BaseServiceNodeImpl(((ServiceNode)capability.getValue()).getNodeName());
                if (!this.weightedGraph.containsVertex((Object)sourceNode)) {
                    this.weightedGraph.addVertex((Object)sourceNode);
                }
                if (!this.weightedGraph.containsVertex((Object)targetNode)) {
                    this.weightedGraph.addVertex((Object)targetNode);
                }
                if (this.weightedGraph.containsEdge((Object)(flowEdge = new LoadBasedFlowEdgeImpl((ServiceNode)sourceNode, (ServiceNode)targetNode, this.defaultFlowEdgeProps, topologySpec.getSpecExecutor())))) continue;
                this.weightedGraph.addEdge((Object)sourceNode, (Object)targetNode, (Object)flowEdge);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Instrumented.markMeter((Optional)this.flowCompilationFailedMeter);
            throw new RuntimeException("Cannot determine topology capabilities", e);
        }
    }

    private JobSpec buildJobSpec(ServiceNode sourceNode, ServiceNode targetNode, URI templateURI, FlowSpec flowSpec) {
        JobSpec jobSpec;
        JobSpec.Builder jobSpecBuilder = JobSpec.builder((URI)this.jobSpecURIGenerator(flowSpec, sourceNode, targetNode)).withConfig(flowSpec.getConfig()).withDescription(flowSpec.getDescription()).withVersion(flowSpec.getVersion());
        if (templateURI != null) {
            jobSpecBuilder.withTemplate(templateURI);
            try {
                jobSpec = new ResolvedJobSpec(jobSpecBuilder.build(), (JobCatalog)this.templateCatalog.get());
                log.info("Resolved JobSpec properties are: " + jobSpec.getConfigAsProperties());
            }
            catch (JobTemplate.TemplateException | SpecNotFoundException e) {
                throw new RuntimeException("Could not resolve template in JobSpec from TemplateCatalog", e);
            }
        } else {
            jobSpec = jobSpecBuilder.build();
            log.info("Unresolved JobSpec properties are: " + jobSpec.getConfigAsProperties());
        }
        jobSpec.setConfig(jobSpec.getConfig().withoutPath("job.schedule"));
        if (flowSpec.getConfig().hasPath("flow.name")) {
            jobSpec.setConfig(jobSpec.getConfig().withValue("job.name", ConfigValueFactory.fromAnyRef((Object)(flowSpec.getConfig().getValue("flow.name").unwrapped().toString() + "-" + sourceNode.getNodeName() + "-" + targetNode.getNodeName()))));
        }
        if (flowSpec.getConfig().hasPath("flow.group")) {
            jobSpec.setConfig(jobSpec.getConfig().withValue("job.group", flowSpec.getConfig().getValue("flow.group")));
        }
        long flowExecutionId = System.currentTimeMillis();
        jobSpec.setConfig(jobSpec.getConfig().withValue("flow.executionId", ConfigValueFactory.fromAnyRef((Object)flowExecutionId)));
        jobSpec.setConfigAsProperties(ConfigUtils.configToProperties((Config)jobSpec.getConfig()));
        return jobSpec;
    }

    private JobSpec convertHopToJobSpec(ServiceNode sourceNode, ServiceNode targetNode, FlowSpec flowSpec) {
        FlowEdge flowEdge = (FlowEdge)this.weightedGraph.getAllEdges((Object)sourceNode, (Object)targetNode).iterator().next();
        URI templateURI = this.getTemplateURI(sourceNode, targetNode, flowSpec, flowEdge);
        return this.buildJobSpec(sourceNode, targetNode, templateURI, flowSpec);
    }

    private URI getTemplateURI(ServiceNode sourceNode, ServiceNode targetNode, FlowSpec flowSpec, FlowEdge flowEdge) {
        URI firstTemplateURI = this.edgeTemplateMap != null && this.edgeTemplateMap.containsKey(flowEdge.getEdgeIdentity()) ? (URI)((List)this.edgeTemplateMap.get(flowEdge.getEdgeIdentity())).get(0) : this.jobSpecTemplateURIGenerator(flowSpec);
        return firstTemplateURI;
    }

    @Override
    public URI jobSpecURIGenerator(Object ... objects) {
        FlowSpec flowSpec = (FlowSpec)objects[0];
        ServiceNode sourceNode = (ServiceNode)objects[1];
        ServiceNode targetNode = (ServiceNode)objects[2];
        try {
            return new URI("gobblin-job", flowSpec.getUri().getAuthority(), StringUtils.appendIfMissing((String)StringUtils.prependIfMissing((String)flowSpec.getUri().getPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + sourceNode.getNodeName() + "-" + targetNode.getNodeName(), null);
        }
        catch (URISyntaxException e) {
            log.error("URI construction failed when jobSpec from " + sourceNode.getNodeName() + " to " + targetNode.getNodeName());
            throw new RuntimeException();
        }
    }

    public DirectedWeightedMultigraph<ServiceNode, FlowEdge> getWeightedGraph() {
        return this.weightedGraph;
    }
}

