/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.data;

import com.linkedin.data.schema.AbstractSchemaEncoder;
import com.linkedin.data.schema.AbstractSchemaParser;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.SchemaToPdlEncoder;
import com.linkedin.data.schema.resolver.MultiFormatDataSchemaResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFormatTranslator {
    private static final Logger _log = LoggerFactory.getLogger(SchemaFormatTranslator.class);
    private static final Options _options = new Options();
    private String _resolverPath;
    private File _sourceDir;
    private File _destDir;
    private String _sourceFormat;
    private String _destFormat;

    public static void main(String[] args) throws Exception {
        try {
            GnuParser parser = new GnuParser();
            CommandLine cl = parser.parse(_options, args);
            if (cl.hasOption('h')) {
                SchemaFormatTranslator.help();
                System.exit(0);
            }
            String sourceFormat = cl.getOptionValue('s', "pdsc");
            String destFormat = cl.getOptionValue('d', "pdl");
            String[] cliArgs = cl.getArgs();
            if (cliArgs.length != 3) {
                _log.error("Missing arguments, expected 3 ([resourcePath] [sourceRoot] [destinationPath]), got " + cliArgs.length);
                SchemaFormatTranslator.help();
                System.exit(1);
            }
            int i = 0;
            String resolverPaths = cliArgs[i++];
            String sourcePath = cliArgs[i++];
            String destPath = cliArgs[i++];
            File sourceDir = new File(sourcePath);
            File destDir = new File(destPath);
            if (!sourceDir.exists() || !sourceDir.canRead()) {
                _log.error("Source directory does not exist or cannot be read: " + sourceDir.getAbsolutePath());
                System.exit(1);
            }
            destDir.mkdirs();
            if (!destDir.exists() || !destDir.canWrite()) {
                _log.error("Destination directory does not exist or cannot be written to: " + destDir.getAbsolutePath());
                System.exit(1);
            }
            SchemaFormatTranslator translator = new SchemaFormatTranslator(resolverPaths, sourceDir, destDir, sourceFormat, destFormat);
            translator.translateFiles();
        }
        catch (ParseException e) {
            _log.error("Invalid arguments: " + e.getMessage());
            SchemaFormatTranslator.help();
            System.exit(1);
        }
    }

    public SchemaFormatTranslator(String resolverPath, File sourceDir, File destDir, String sourceFormat, String destFormat) {
        this._resolverPath = resolverPath;
        this._sourceDir = sourceDir;
        this._destDir = destDir;
        this._sourceFormat = sourceFormat;
        this._destFormat = destFormat;
    }

    private void translateFiles() throws IOException {
        Iterator iter = FileUtils.iterateFiles((File)this._sourceDir, (String[])new String[]{this._sourceFormat}, (boolean)true);
        while (iter.hasNext()) {
            File sourceFile = (File)iter.next();
            String relativePath = this._sourceDir.toURI().relativize(sourceFile.toURI()).getPath();
            String relativeMinusExt = SchemaFormatTranslator.trimFileExtension(relativePath);
            String schemaFullname = relativeMinusExt.replace(File.separatorChar, '.');
            File destinationFile = new File(this._destDir, relativeMinusExt + "." + this._destFormat);
            File path = destinationFile.getParentFile();
            path.mkdirs();
            if (!path.exists() || !path.canWrite()) {
                _log.error("Unable to create or cannot write to destination directory: " + path.getAbsolutePath());
                System.exit(1);
            }
            this.translateFile(sourceFile, destinationFile, schemaFullname);
        }
    }

    private void translateFile(File sourceFile, File destinationFile, String schemaFullname) throws IOException {
        MultiFormatDataSchemaResolver resolver = MultiFormatDataSchemaResolver.withBuiltinFormats((String)this._resolverPath);
        PegasusSchemaParser parser = AbstractSchemaParser.parserForFileExtension((String)this._sourceFormat, (DataSchemaResolver)resolver);
        parser.parse((InputStream)new FileInputStream(sourceFile));
        SchemaFormatTranslator.checkForErrors(this._resolverPath, sourceFile, schemaFullname, parser);
        List topLevelSchemas = parser.topLevelDataSchemas();
        if (topLevelSchemas.size() == 1) {
            DataSchema schema = (DataSchema)topLevelSchemas.get(0);
            String encoded = SchemaFormatTranslator.encode(schema, this._destFormat);
            _log.debug("Writing " + destinationFile.getAbsolutePath());
            FileUtils.writeStringToFile((File)destinationFile, (String)encoded);
        } else {
            _log.error("Expected one top level schema for " + destinationFile.getAbsolutePath() + " but got " + topLevelSchemas.size());
        }
    }

    private static void checkForErrors(String resolverPath, File file, String schemaFullname, PegasusSchemaParser parser) {
        StringBuilder errorMessageBuilder = parser.errorMessageBuilder();
        if (errorMessageBuilder.length() > 0) {
            _log.error("Failed to parse schema: " + file.getAbsolutePath() + "\nfullname: " + schemaFullname + "\nerrors: " + errorMessageBuilder.toString() + "\nresolverPath: " + resolverPath);
            System.exit(1);
        }
        if (parser.topLevelDataSchemas().size() != 1) {
            _log.error("Failed to parse any schemas from: " + file.getAbsolutePath() + "\nfullname: " + schemaFullname + "\nerrors: " + errorMessageBuilder.toString() + "\nresolverPath: " + resolverPath);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encode(DataSchema schema, String format) throws IOException {
        if (format.equals("pdl")) {
            StringWriter writer = new StringWriter();
            SchemaToPdlEncoder encoder = new SchemaToPdlEncoder((Writer)writer);
            encoder.setTypeReferenceFormat(AbstractSchemaEncoder.TypeReferenceFormat.PRESERVE);
            encoder.encode(schema);
            return writer.toString();
        }
        if (format.equals("pdsc")) {
            JsonBuilder.Pretty pretty = JsonBuilder.Pretty.INDENTED;
            JsonBuilder builder = new JsonBuilder(pretty);
            try {
                SchemaToJsonEncoder encoder = new SchemaToJsonEncoder(builder, AbstractSchemaEncoder.TypeReferenceFormat.PRESERVE);
                encoder.encode(schema);
                String string = builder.result();
                return string;
            }
            finally {
                builder.closeQuietly();
            }
        }
        throw new IllegalArgumentException("Unsupported format: " + format);
    }

    private static String trimFileExtension(String path) {
        return path.substring(0, path.lastIndexOf(46));
    }

    private static void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(120, SchemaFormatTranslator.class.getSimpleName(), "[resolverPath] [sourceRoot] [destinationPath]", _options, "", true);
    }

    static {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print help");
        _options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"source-format");
        OptionBuilder.withArgName((String)"(pdl|pdsc)");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Source file format ('pdsc' by default)");
        _options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"destination-format");
        OptionBuilder.withArgName((String)"(pdl|pdsc)");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Destination file format ('pdl' by default)");
        _options.addOption(OptionBuilder.create((char)'d'));
    }
}

