/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.metastore;

import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveLock;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.hive.HivePartition;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.HiveRegistrationUnit;
import org.apache.gobblin.hive.HiveTable;
import org.apache.gobblin.hive.metastore.HiveMetaStoreEventHelper;
import org.apache.gobblin.hive.metastore.HiveMetaStoreUtils;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.GobblinMetricsRegistry;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.AutoCloseableLock;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class HiveMetaStoreBasedRegister
extends HiveRegister {
    private static final Logger log = LoggerFactory.getLogger(HiveMetaStoreBasedRegister.class);
    public static final String HIVE_REGISTER_METRICS_PREFIX = "hiveRegister.";
    public static final String ADD_PARTITION_TIMER = "hiveRegister.addPartitionTimerTimer";
    public static final String GET_HIVE_PARTITION = "hiveRegister.getPartitionTimer";
    public static final String ALTER_PARTITION = "hiveRegister.alterPartitionTimer";
    public static final String TABLE_EXISTS = "hiveRegister.tableExistsTimer";
    public static final String ALTER_TABLE = "hiveRegister.alterTableTimer";
    public static final String GET_HIVE_DATABASE = "hiveRegister.getDatabaseTimer";
    public static final String CREATE_HIVE_DATABASE = "hiveRegister.createDatabaseTimer";
    public static final String CREATE_HIVE_TABLE = "hiveRegister.createTableTimer";
    public static final String GET_HIVE_TABLE = "hiveRegister.getTableTimer";
    public static final String DROP_TABLE = "hiveRegister.dropTableTimer";
    public static final String PATH_REGISTER_TIMER = "hiveRegister.pathRegisterTimer";
    public static final String OPTIMIZED_CHECK_ENABLED = "hiveRegister.cacheDbTableExistence";
    private final HiveMetastoreClientPool clientPool;
    private final HiveLock locks = new HiveLock();
    private final EventSubmitter eventSubmitter;
    private final MetricContext metricContext;
    CacheLoader<String, Boolean> cacheLoader = new CacheLoader<String, Boolean>(){

        public Boolean load(String key) throws Exception {
            return true;
        }
    };
    Cache<String, Boolean> tableAndDbExistenceCache = CacheBuilder.newBuilder().build(this.cacheLoader);
    private final boolean optimizedChecks;

    public HiveMetaStoreBasedRegister(State state, Optional<String> metastoreURI) throws IOException {
        super(state);
        this.optimizedChecks = state.getPropAsBoolean(OPTIMIZED_CHECK_ENABLED, true);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.props.getNumThreads());
        config.setMaxIdle(this.props.getNumThreads());
        this.clientPool = HiveMetastoreClientPool.get(this.props.getProperties(), metastoreURI);
        this.metricContext = GobblinMetricsRegistry.getInstance().getMetricContext(state, HiveMetaStoreBasedRegister.class, GobblinMetrics.getCustomTagsFromState((State)state));
        this.eventSubmitter = new EventSubmitter.Builder(this.metricContext, "org.apache.gobblin.hive.HiveMetaStoreBasedRegister").build();
    }

    @Override
    protected void registerPath(HiveSpec spec) throws IOException {
        try (Timer.Context context = this.metricContext.timer(PATH_REGISTER_TIMER).time();
             AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
            Table table = HiveMetaStoreUtils.getTable(spec.getTable());
            this.createDbIfNotExists((IMetaStoreClient)client.get(), table.getDbName());
            this.createOrAlterTable((IMetaStoreClient)client.get(), table, spec);
            Optional<HivePartition> partition = spec.getPartition();
            if (partition.isPresent()) {
                this.addOrAlterPartition((IMetaStoreClient)client.get(), table, HiveMetaStoreUtils.getPartition((HivePartition)partition.get()), spec);
            }
            HiveMetaStoreEventHelper.submitSuccessfulPathRegistration(this.eventSubmitter, spec);
        }
        catch (TException e) {
            HiveMetaStoreEventHelper.submitFailedPathRegistration(this.eventSubmitter, spec, (Exception)((Object)e));
            throw new IOException(e);
        }
    }

    @Override
    public boolean createDbIfNotExists(String dbName) throws IOException {
        try (AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
            boolean bl = this.createDbIfNotExists((IMetaStoreClient)client.get(), dbName);
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean ensureHiveTableExistenceBeforeAlternation(String tableName, String dbName, IMetaStoreClient client, Table table, HiveSpec spec) throws TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 23[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean ensureHiveDbExistence(String hiveDbName, IMetaStoreClient client) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean createDbIfNotExists(final IMetaStoreClient client, final String dbName) throws IOException {
        if (this.optimizedChecks) {
            boolean retVal;
            try {
                retVal = (Boolean)this.tableAndDbExistenceCache.get((Object)dbName, (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return HiveMetaStoreBasedRegister.this.ensureHiveDbExistence(dbName, client);
                    }
                });
            }
            catch (ExecutionException ee) {
                throw new IOException("Database existence checking throwing execution exception.");
            }
            return retVal;
        }
        return this.ensureHiveDbExistence(dbName, client);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean createTableIfNotExists(HiveTable table) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean addPartitionIfNotExists(HiveTable table, HivePartition partition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createTableIfNotExists(IMetaStoreClient client, Table table, HiveTable hiveTable) throws IOException {
        String dbName = table.getDbName();
        String tableName = table.getTableName();
        try (AutoCloseableLock lock = this.locks.getTableLock(dbName, tableName);){
            boolean tableExists;
            try (Timer.Context context = this.metricContext.timer(TABLE_EXISTS).time();){
                tableExists = client.tableExists(table.getDbName(), table.getTableName());
            }
            if (tableExists) {
                boolean context = false;
                return context;
            }
            context = this.metricContext.timer(CREATE_HIVE_TABLE).time();
            var10_12 = null;
            try {
                client.createTable(this.getTableWithCreateTimeNow(table));
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var10_12 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var10_12.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            log.info(String.format("Created Hive table %s in db %s", tableName, dbName));
            HiveMetaStoreEventHelper.submitSuccessfulTableCreation(this.eventSubmitter, hiveTable);
            boolean bl = true;
            return bl;
        }
        catch (TException e) {
            HiveMetaStoreEventHelper.submitFailedTableCreation(this.eventSubmitter, hiveTable, (Exception)((Object)e));
            throw new IOException(String.format("Error in creating or altering Hive table %s in db %s", table.getTableName(), table.getDbName()), e);
        }
    }

    private void createOrAlterTable(final IMetaStoreClient client, final Table table, final HiveSpec spec) throws TException, IOException {
        final String dbName = table.getDbName();
        final String tableName = table.getTableName();
        if (this.optimizedChecks) {
            try {
                this.tableAndDbExistenceCache.get((Object)(dbName + ":" + tableName), (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return HiveMetaStoreBasedRegister.this.ensureHiveTableExistenceBeforeAlternation(tableName, dbName, client, table, spec);
                    }
                });
            }
            catch (ExecutionException ee) {
                throw new IOException("Table existence checking throwing execution exception.");
            }
        } else {
            this.ensureHiveTableExistenceBeforeAlternation(tableName, dbName, client, table, spec);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean existsTable(String dbName, String tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsPartition(String dbName, String tableName, List<HiveRegistrationUnit.Column> partitionKeys, List<String> partitionValues) throws IOException {
        try (AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
            try (Timer.Context context = this.metricContext.timer(GET_HIVE_PARTITION).time();){
                ((IMetaStoreClient)client.get()).getPartition(dbName, tableName, partitionValues);
            }
            boolean bl = true;
            return bl;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new IOException(String.format("Unable to check existence of partition %s in table %s in db %s", partitionValues, tableName, dbName), e);
        }
    }

    @Override
    public void dropTableIfExists(String dbName, String tableName) throws IOException {
        block39: {
            try (AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
                boolean tableExists;
                try (Timer.Context context = this.metricContext.timer(TABLE_EXISTS).time();){
                    tableExists = ((IMetaStoreClient)client.get()).tableExists(dbName, tableName);
                }
                if (!tableExists) break block39;
                context = this.metricContext.timer(DROP_TABLE).time();
                var7_7 = null;
                try {
                    ((IMetaStoreClient)client.get()).dropTable(dbName, tableName);
                }
                catch (Throwable throwable) {
                    var7_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (context != null) {
                        if (var7_7 != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            context.close();
                        }
                    }
                }
                String metastoreURI = this.clientPool.getHiveConf().get("hive.metastore.token.signature", "null");
                HiveMetaStoreEventHelper.submitSuccessfulTableDrop(this.eventSubmitter, dbName, tableName, metastoreURI);
                log.info("Dropped table " + tableName + " in db " + dbName);
            }
            catch (TException e) {
                HiveMetaStoreEventHelper.submitFailedTableDrop(this.eventSubmitter, dbName, tableName, (Exception)((Object)e));
                throw new IOException(String.format("Unable to deregister table %s in db %s", tableName, dbName), e);
            }
        }
    }

    @Override
    public void dropPartitionIfExists(String dbName, String tableName, List<HiveRegistrationUnit.Column> partitionKeys, List<String> partitionValues) throws IOException {
        try (AutoReturnableObject<IMetaStoreClient> client2 = this.clientPool.getClient();){
            try (Timer.Context context = this.metricContext.timer(DROP_TABLE).time();){
                ((IMetaStoreClient)client2.get()).dropPartition(dbName, tableName, partitionValues, false);
            }
            String metastoreURI = this.clientPool.getHiveConf().get("hive.metastore.token.signature", "null");
            HiveMetaStoreEventHelper.submitSuccessfulPartitionDrop(this.eventSubmitter, dbName, tableName, partitionValues, metastoreURI);
            log.info("Dropped partition " + partitionValues + " in table " + tableName + " in db " + dbName);
        }
        catch (NoSuchObjectException client2) {
        }
        catch (TException e) {
            HiveMetaStoreEventHelper.submitFailedPartitionDrop(this.eventSubmitter, dbName, tableName, partitionValues, (Exception)((Object)e));
            throw new IOException(String.format("Unable to check existence of Hive partition %s in table %s in db %s", partitionValues, tableName, dbName), e);
        }
    }

    private void addOrAlterPartition(IMetaStoreClient client, Table table, Partition partition, HiveSpec spec) throws TException {
        block54: {
            Preconditions.checkArgument((table.getPartitionKeysSize() == partition.getValues().size() ? 1 : 0) != 0, (Object)String.format("Partition key size is %s but partition value size is %s", table.getPartitionKeys().size(), partition.getValues().size()));
            try (AutoCloseableLock lock = this.locks.getPartitionLock(table.getDbName(), table.getTableName(), partition.getValues());){
                try {
                    try (Timer.Context context = this.metricContext.timer(ADD_PARTITION_TIMER).time();){
                        client.add_partition(this.getPartitionWithCreateTimeNow(partition));
                    }
                    log.info(String.format("Added partition %s to table %s with location %s", HiveMetaStoreBasedRegister.stringifyPartition(partition), table.getTableName(), partition.getSd().getLocation()));
                }
                catch (TException e) {
                    try {
                        HivePartition existingPartition;
                        try (Timer.Context context = this.metricContext.timer(GET_HIVE_PARTITION).time();){
                            existingPartition = HiveMetaStoreUtils.getHivePartition(client.getPartition(table.getDbName(), table.getTableName(), partition.getValues()));
                        }
                        if (this.needToUpdatePartition(existingPartition, (HivePartition)spec.getPartition().get())) {
                            log.info(String.format("Partition update required. ExistingPartition %s, newPartition %s", HiveMetaStoreBasedRegister.stringifyPartition(existingPartition), HiveMetaStoreBasedRegister.stringifyPartition((HivePartition)spec.getPartition().get())));
                            Partition newPartition = this.getPartitionWithCreateTime(partition, existingPartition);
                            log.info(String.format("Altering partition %s", newPartition));
                            try (Timer.Context context = this.metricContext.timer(ALTER_PARTITION).time();){
                                client.alter_partition(table.getDbName(), table.getTableName(), newPartition);
                            }
                            log.info(String.format("Updated partition %s in table %s with location %s", HiveMetaStoreBasedRegister.stringifyPartition(newPartition), table.getTableName(), partition.getSd().getLocation()));
                            break block54;
                        }
                        log.info(String.format("Partition %s in table %s with location %s already exists and no need to update", HiveMetaStoreBasedRegister.stringifyPartition(partition), table.getTableName(), partition.getSd().getLocation()));
                    }
                    catch (Throwable e2) {
                        log.error(String.format("Unable to add or alter partition %s in table %s with location %s: " + e2.getMessage(), HiveMetaStoreBasedRegister.stringifyPartitionVerbose(partition), table.getTableName(), partition.getSd().getLocation()), e2);
                        throw e2;
                    }
                }
            }
        }
    }

    private static String stringifyPartition(Partition partition) {
        if (log.isDebugEnabled()) {
            return HiveMetaStoreBasedRegister.stringifyPartitionVerbose(partition);
        }
        return Arrays.toString(partition.getValues().toArray());
    }

    private static String stringifyPartition(HivePartition partition) {
        return partition.toString();
    }

    private static String stringifyPartitionVerbose(Partition partition) {
        return partition.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<HiveTable> getTable(String dbName, String tableName) throws IOException {
        try (AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
            Table hiveTable;
            try (Timer.Context context = this.metricContext.timer(GET_HIVE_TABLE).time();){
                hiveTable = ((IMetaStoreClient)client.get()).getTable(dbName, tableName);
            }
            Optional optional = Optional.of((Object)HiveMetaStoreUtils.getHiveTable(hiveTable));
            return optional;
        }
        catch (NoSuchObjectException e) {
            return Optional.absent();
        }
        catch (TException e) {
            throw new IOException("Unable to get table " + tableName + " in db " + dbName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<HivePartition> getPartition(String dbName, String tableName, List<HiveRegistrationUnit.Column> partitionKeys, List<String> partitionValues) throws IOException {
        try (AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
            Partition hivePartition;
            try (Timer.Context context = this.metricContext.timer(GET_HIVE_PARTITION).time();){
                hivePartition = ((IMetaStoreClient)client.get()).getPartition(dbName, tableName, partitionValues);
            }
            Optional optional = Optional.of((Object)HiveMetaStoreUtils.getHivePartition(hivePartition));
            return optional;
        }
        catch (NoSuchObjectException e) {
            return Optional.absent();
        }
        catch (TException e) {
            throw new IOException("Unable to get partition " + partitionValues + " from table " + tableName + " in db " + dbName, e);
        }
    }

    @Override
    public void alterTable(HiveTable table) throws IOException {
        try (AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
            boolean tableExists;
            try (Timer.Context context = this.metricContext.timer(TABLE_EXISTS).time();){
                tableExists = ((IMetaStoreClient)client.get()).tableExists(table.getDbName(), table.getTableName());
            }
            if (!tableExists) {
                throw new IOException("Table " + table.getTableName() + " in db " + table.getDbName() + " does not exist");
            }
            context = this.metricContext.timer(ALTER_TABLE).time();
            var6_6 = null;
            try {
                ((IMetaStoreClient)client.get()).alter_table(table.getDbName(), table.getTableName(), this.getTableWithCreateTimeNow(HiveMetaStoreUtils.getTable(table)));
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var6_6 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            HiveMetaStoreEventHelper.submitSuccessfulTableAlter(this.eventSubmitter, table);
        }
        catch (TException e) {
            HiveMetaStoreEventHelper.submitFailedTableAlter(this.eventSubmitter, table, (Exception)((Object)e));
            throw new IOException("Unable to alter table " + table.getTableName() + " in db " + table.getDbName(), e);
        }
    }

    @Override
    public void alterPartition(HiveTable table, HivePartition partition) throws IOException {
        try (AutoReturnableObject<IMetaStoreClient> client = this.clientPool.getClient();){
            try (Timer.Context context = this.metricContext.timer(ALTER_PARTITION).time();){
                ((IMetaStoreClient)client.get()).alter_partition(table.getDbName(), table.getTableName(), this.getPartitionWithCreateTimeNow(HiveMetaStoreUtils.getPartition(partition)));
            }
            HiveMetaStoreEventHelper.submitSuccessfulPartitionAlter(this.eventSubmitter, table, partition);
        }
        catch (TException e) {
            HiveMetaStoreEventHelper.submitFailedPartitionAlter(this.eventSubmitter, table, partition, (Exception)((Object)e));
            throw new IOException(String.format("Unable to alter partition %s in table %s in db %s", partition.getValues(), table.getTableName(), table.getDbName()), e);
        }
    }

    private Partition getPartitionWithCreateTimeNow(Partition partition) {
        return this.getPartitionWithCreateTime(partition, Ints.checkedCast((long)(DateTime.now().getMillis() / 1000L)));
    }

    private Partition getPartitionWithCreateTime(Partition partition, HivePartition referencePartition) {
        return this.getPartitionWithCreateTime(partition, Ints.checkedCast((long)((Long)referencePartition.getCreateTime().or((Object)(DateTime.now().getMillis() / 1000L)))));
    }

    private Partition getPartitionWithCreateTime(Partition partition, int createTime) {
        if (partition.isSetCreateTime() && partition.getCreateTime() > 0) {
            return partition;
        }
        Partition actualPartition = partition.deepCopy();
        actualPartition.setCreateTime(createTime);
        return actualPartition;
    }

    private Table getTableWithCreateTimeNow(Table table) {
        return this.gettableWithCreateTime(table, Ints.checkedCast((long)(DateTime.now().getMillis() / 1000L)));
    }

    private Table getTableWithCreateTime(Table table, HiveTable referenceTable) {
        return this.gettableWithCreateTime(table, Ints.checkedCast((long)((Long)referenceTable.getCreateTime().or((Object)(DateTime.now().getMillis() / 1000L)))));
    }

    private Table gettableWithCreateTime(Table table, int createTime) {
        if (table.isSetCreateTime() && table.getCreateTime() > 0) {
            return table;
        }
        Table actualtable = table.deepCopy();
        actualtable.setCreateTime(createTime);
        return actualtable;
    }
}

