/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.CommunicationException;
import com.microsoft.azure.servicebus.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.ExceptionUtil;
import com.microsoft.azure.servicebus.IConnectionFactory;
import com.microsoft.azure.servicebus.RetryPolicy;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import com.microsoft.azure.servicebus.TimeoutException;
import com.microsoft.azure.servicebus.Timer;
import com.microsoft.azure.servicebus.TimerType;
import com.microsoft.azure.servicebus.amqp.BaseLinkHandler;
import com.microsoft.azure.servicebus.amqp.ConnectionHandler;
import com.microsoft.azure.servicebus.amqp.DispatchHandler;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import com.microsoft.azure.servicebus.amqp.ProtonUtil;
import com.microsoft.azure.servicebus.amqp.ReactorDispatcher;
import com.microsoft.azure.servicebus.amqp.ReactorHandler;
import java.io.IOException;
import java.nio.channels.UnresolvedAddressException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.reactor.Reactor;

public class MessagingFactory
extends ClientEntity
implements IAmqpConnection,
IConnectionFactory {
    public static final Duration DefaultOperationTimeout = Duration.ofSeconds(60L);
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private final String hostName;
    private final CompletableFuture<Void> closeTask;
    private final ConnectionHandler connectionHandler;
    private final LinkedList<Link> registeredLinks;
    private final Object reactorLock;
    private Reactor reactor;
    private ReactorDispatcher reactorScheduler;
    private Connection connection;
    private Duration operationTimeout;
    private RetryPolicy retryPolicy;
    private CompletableFuture<MessagingFactory> open;
    private CompletableFuture<Connection> openConnection;

    MessagingFactory(ConnectionStringBuilder builder) {
        super("MessagingFactory".concat(StringUtil.getRandomString()), null);
        Timer.register(this.getClientId());
        this.hostName = builder.getEndpoint().getHost();
        this.operationTimeout = builder.getOperationTimeout();
        this.retryPolicy = builder.getRetryPolicy();
        this.registeredLinks = new LinkedList();
        this.reactorLock = new Object();
        this.connectionHandler = new ConnectionHandler(this, builder.getSasKeyName(), builder.getSasKey());
        this.openConnection = new CompletableFuture();
        this.closeTask = new CompletableFuture();
        this.closeTask.thenAccept((Consumer)new Consumer<Void>(){

            @Override
            public void accept(Void arg0) {
                Timer.unregister(MessagingFactory.this.getClientId());
            }
        });
    }

    String getHostName() {
        return this.hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reactor getReactor() {
        Object object = this.reactorLock;
        synchronized (object) {
            return this.reactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactorDispatcher getReactorScheduler() {
        Object object = this.reactorLock;
        synchronized (object) {
            return this.reactorScheduler;
        }
    }

    private void createConnection(ConnectionStringBuilder builder) throws IOException {
        this.open = new CompletableFuture();
        this.startReactor(new ReactorHandler(){

            @Override
            public void onReactorInit(Event e) {
                super.onReactorInit(e);
                Reactor r = e.getReactor();
                MessagingFactory.this.connection = r.connectionToHost(MessagingFactory.this.hostName, 5671, (Handler)MessagingFactory.this.connectionHandler);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReactor(ReactorHandler reactorHandler) throws IOException {
        Reactor newReactor = ProtonUtil.reactor(reactorHandler);
        Object object = this.reactorLock;
        synchronized (object) {
            this.reactor = newReactor;
            this.reactorScheduler = new ReactorDispatcher(newReactor);
        }
        Thread reactorThread = new Thread(new RunReactor(newReactor));
        reactorThread.start();
    }

    @Override
    public Connection getConnection() {
        if (this.connection == null || this.connection.getLocalState() == EndpointState.CLOSED || this.connection.getRemoteState() == EndpointState.CLOSED) {
            this.connection = this.getReactor().connectionToHost(this.hostName, 5671, (Handler)this.connectionHandler);
        }
        return this.connection;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString) throws IOException {
        ConnectionStringBuilder builder = new ConnectionStringBuilder(connectionString);
        MessagingFactory messagingFactory = new MessagingFactory(builder);
        messagingFactory.createConnection(builder);
        return messagingFactory.open;
    }

    @Override
    public void onOpenComplete(Exception exception) {
        if (exception == null) {
            this.open.complete(this);
            this.openConnection.complete(this.connection);
        } else {
            this.open.completeExceptionally(exception);
            this.openConnection.completeExceptionally(exception);
        }
    }

    @Override
    public void onConnectionError(ErrorCondition error) {
        if (!this.open.isDone()) {
            this.onOpenComplete(ExceptionUtil.toException(error));
        } else {
            Connection currentConnection = this.connection;
            for (Link link : this.registeredLinks) {
                if (link.getLocalState() == EndpointState.CLOSED || link.getRemoteState() == EndpointState.CLOSED) continue;
                link.close();
            }
            this.openConnection = new CompletableFuture();
            if (currentConnection.getLocalState() != EndpointState.CLOSED && currentConnection.getRemoteState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            for (Link link : this.registeredLinks) {
                Handler handler = BaseHandler.getHandler((Extendable)link);
                if (handler == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, error);
            }
        }
        if (this.getIsClosingOrClosed() && !this.closeTask.isDone()) {
            this.getReactor().stop();
        }
    }

    private void onReactorError(Exception cause) {
        if (!this.open.isDone()) {
            this.onOpenComplete(cause);
        } else {
            Connection currentConnection = this.connection;
            try {
                if (this.getIsClosingOrClosed()) {
                    return;
                }
                this.startReactor(new ReactorHandler());
            }
            catch (IOException e) {
                TRACE_LOGGER.log(Level.SEVERE, ExceptionUtil.toStackTraceString(e, "Re-starting reactor failed with error"));
                this.onReactorError(cause);
            }
            if (currentConnection.getLocalState() != EndpointState.CLOSED && currentConnection.getRemoteState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            for (Link link : this.registeredLinks) {
                Handler handler;
                if (link.getLocalState() != EndpointState.CLOSED && link.getRemoteState() != EndpointState.CLOSED) {
                    link.close();
                }
                if ((handler = BaseHandler.getHandler((Extendable)link)) == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, cause);
            }
        }
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (!this.getIsClosed()) {
            try {
                this.scheduleOnReactorThread(new CloseWork());
            }
            catch (IOException ioException) {
                this.closeTask.completeExceptionally(new ServiceBusException(false, "Failed to Close MessagingFactory, see cause for more details.", ioException));
            }
        }
        return this.closeTask;
    }

    @Override
    public void registerForConnectionError(Link link) {
        this.registeredLinks.add(link);
    }

    @Override
    public void deregisterForConnectionError(Link link) {
        this.registeredLinks.remove(link);
    }

    public void scheduleOnReactorThread(DispatchHandler handler) throws IOException {
        this.getReactorScheduler().invoke(handler);
    }

    public void scheduleOnReactorThread(int delay, DispatchHandler handler) throws IOException {
        this.getReactorScheduler().invoke(delay, handler);
    }

    private class RunReactor
    implements Runnable {
        private final Reactor rctr;

        public RunReactor(Reactor reactor) {
            this.rctr = reactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, "starting reactor instance.");
            }
            try {
                this.rctr.setTimeout(3141L);
                this.rctr.start();
                while (!Thread.interrupted() && this.rctr.process()) {
                }
                this.rctr.stop();
            }
            catch (HandlerException handlerException) {
                Throwable cause = handlerException.getCause();
                if (cause == null) {
                    cause = handlerException;
                }
                if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
                    TRACE_LOGGER.log(Level.WARNING, ExceptionUtil.toStackTraceString(handlerException, "UnHandled exception while processing events in reactor:"));
                }
                String message = !StringUtil.isNullOrEmpty(cause.getMessage()) ? cause.getMessage() : (!StringUtil.isNullOrEmpty(handlerException.getMessage()) ? handlerException.getMessage() : "Reactor encountered unrecoverable error");
                ServiceBusException sbException = new ServiceBusException(true, String.format(Locale.US, "%s, %s", message, ExceptionUtil.getTrackingIDAndTimeToLog()), cause);
                if (cause instanceof UnresolvedAddressException) {
                    sbException = new CommunicationException(String.format(Locale.US, "%s. This is usually caused by incorrect hostname or network configuration. Please check to see if namespace information is correct. %s", message, ExceptionUtil.getTrackingIDAndTimeToLog()), cause);
                }
                MessagingFactory.this.onReactorError(sbException);
            }
            finally {
                this.rctr.free();
                if (MessagingFactory.this.getIsClosingOrClosed() && !MessagingFactory.this.closeTask.isDone()) {
                    MessagingFactory.this.closeTask.complete(null);
                }
            }
        }
    }

    private class CloseWork
    extends DispatchHandler {
        private CloseWork() {
        }

        @Override
        public void onEvent() {
            if (MessagingFactory.this.connection != null && MessagingFactory.this.connection.getRemoteState() != EndpointState.CLOSED) {
                if (MessagingFactory.this.connection.getLocalState() != EndpointState.CLOSED) {
                    MessagingFactory.this.connection.close();
                }
                Timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (!MessagingFactory.this.closeTask.isDone()) {
                            MessagingFactory.this.closeTask.completeExceptionally(new TimeoutException("Closing MessagingFactory timed out."));
                        }
                    }
                }, MessagingFactory.this.operationTimeout, TimerType.OneTimeRun);
            }
        }
    }
}

