/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.common.impl;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.config.common.impl.ConfigStoreValueInspector;
import org.apache.gobblin.config.store.api.ConfigKeyPath;

public class InMemoryValueInspector
implements ConfigStoreValueInspector {
    private final ConfigStoreValueInspector valueFallback;
    private final Cache<ConfigKeyPath, Config> ownConfigCache;
    private final Cache<ConfigKeyPath, Config> recursiveConfigCache;

    public InMemoryValueInspector(ConfigStoreValueInspector valueFallback, boolean useStrongRef) {
        this.valueFallback = valueFallback;
        if (useStrongRef) {
            this.ownConfigCache = CacheBuilder.newBuilder().build();
            this.recursiveConfigCache = CacheBuilder.newBuilder().build();
        } else {
            this.ownConfigCache = CacheBuilder.newBuilder().softValues().build();
            this.recursiveConfigCache = CacheBuilder.newBuilder().softValues().build();
        }
    }

    @Override
    public Config getOwnConfig(final ConfigKeyPath configKey) {
        try {
            return (Config)this.ownConfigCache.get((Object)configKey, (Callable)new Callable<Config>(){

                @Override
                public Config call() {
                    return InMemoryValueInspector.this.valueFallback.getOwnConfig(configKey);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Can not getOwnConfig for " + configKey);
        }
    }

    @Override
    public Config getResolvedConfig(ConfigKeyPath configKey) {
        return this.getResolvedConfig(configKey, (Optional<Config>)Optional.absent());
    }

    @Override
    public Config getResolvedConfig(final ConfigKeyPath configKey, final Optional<Config> runtimeConfig) {
        try {
            return (Config)this.recursiveConfigCache.get((Object)configKey, (Callable)new Callable<Config>(){

                @Override
                public Config call() {
                    return InMemoryValueInspector.this.valueFallback.getResolvedConfig(configKey, (Optional<Config>)runtimeConfig);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Can not getOwnConfig for " + configKey);
        }
    }

    @Override
    public Map<ConfigKeyPath, Config> getOwnConfigs(Collection<ConfigKeyPath> configKeys) {
        ArrayList<ConfigKeyPath> configKeysNotInCache = new ArrayList<ConfigKeyPath>();
        HashMap<ConfigKeyPath, Config> result = new HashMap<ConfigKeyPath, Config>();
        for (ConfigKeyPath configKey : configKeys) {
            Config cachedValue = (Config)this.ownConfigCache.getIfPresent((Object)configKey);
            if (cachedValue == null) {
                configKeysNotInCache.add(configKey);
                continue;
            }
            result.put(configKey, cachedValue);
        }
        if (configKeysNotInCache.size() > 0) {
            Map<ConfigKeyPath, Config> configsFromFallBack = this.valueFallback.getOwnConfigs(configKeysNotInCache);
            this.ownConfigCache.putAll(configsFromFallBack);
            result.putAll(configsFromFallBack);
        }
        return result;
    }

    @Override
    public Map<ConfigKeyPath, Config> getResolvedConfigs(Collection<ConfigKeyPath> configKeys) {
        ArrayList<ConfigKeyPath> configKeysNotInCache = new ArrayList<ConfigKeyPath>();
        HashMap<ConfigKeyPath, Config> result = new HashMap<ConfigKeyPath, Config>();
        for (ConfigKeyPath configKey : configKeys) {
            Config cachedValue = (Config)this.recursiveConfigCache.getIfPresent((Object)configKey);
            if (cachedValue == null) {
                configKeysNotInCache.add(configKey);
                continue;
            }
            result.put(configKey, cachedValue);
        }
        if (configKeysNotInCache.size() > 0) {
            Map<ConfigKeyPath, Config> configsFromFallBack = this.valueFallback.getResolvedConfigs(configKeysNotInCache);
            this.recursiveConfigCache.putAll(configsFromFallBack);
            result.putAll(configsFromFallBack);
        }
        return result;
    }
}

