/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message;

import com.linkedin.r2.message.MessageHeaders;
import com.linkedin.r2.message.rest.RestUtil;
import com.linkedin.util.ArgumentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class BaseMessage
implements MessageHeaders {
    private final Map<String, String> _headers;
    private final List<String> _cookies;

    protected BaseMessage(Map<String, String> headers, List<String> cookies) {
        ArgumentUtil.notNull(headers, (String)"headers");
        ArgumentUtil.notNull(cookies, (String)"cookies");
        TreeMap<String, String> tmpHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        tmpHeaders.putAll(headers);
        this._headers = Collections.unmodifiableMap(tmpHeaders);
        this._cookies = Collections.unmodifiableList(new ArrayList<String>(cookies));
    }

    @Override
    public String getHeader(String name) {
        return this._headers.get(name);
    }

    @Override
    public List<String> getHeaderValues(String name) {
        String headerVal = this.getHeader(name);
        if (headerVal == null) {
            return null;
        }
        return RestUtil.getHeaderValues(headerVal);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this._headers;
    }

    @Override
    public List<String> getCookies() {
        return this._cookies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseMessage)) {
            return false;
        }
        BaseMessage that = (BaseMessage)o;
        return this._headers.equals(that._headers) && this._cookies.equals(that._cookies);
    }

    public int hashCode() {
        int result = this._headers.hashCode();
        return 31 * result + this._cookies.hashCode();
    }
}

