/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common.bridge.common;

import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import java.util.HashMap;
import java.util.Map;

public class TransportResponseImpl<T>
implements TransportResponse<T> {
    private final T _response;
    private final Throwable _error;
    private final Map<String, String> _wireAttrs;

    public static <T> TransportResponse<T> success(T response) {
        return new TransportResponseImpl<T>(response, null, new HashMap<String, String>());
    }

    public static <T> TransportResponse<T> success(T response, Map<String, String> wireAttrs) {
        return new TransportResponseImpl<T>(response, null, wireAttrs);
    }

    public static <T> TransportResponse<T> error(Throwable error, Map<String, String> wireAttrs) {
        return new TransportResponseImpl<Object>(null, error, wireAttrs);
    }

    public static <T> TransportResponse<T> error(Throwable error) {
        return new TransportResponseImpl<Object>(null, error, new HashMap<String, String>());
    }

    private TransportResponseImpl(T response, Throwable error, Map<String, String> wireAttrs) {
        assert (response != null && error == null || response == null && error != null);
        this._response = response;
        this._error = error;
        this._wireAttrs = wireAttrs;
    }

    @Override
    public T getResponse() {
        return this._response;
    }

    @Override
    public boolean hasError() {
        return this._error != null;
    }

    @Override
    public Throwable getError() {
        return this._error;
    }

    @Override
    public Map<String, String> getWireAttributes() {
        return this._wireAttrs;
    }
}

