/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ClosableQueue<T> {
    private final AtomicInteger _count = new AtomicInteger(0);
    private final BlockingQueue<T> _queue = new LinkedBlockingQueue<T>();
    private final AtomicBoolean _closing = new AtomicBoolean(false);

    public boolean offer(T obj) {
        int count;
        while ((count = this._count.get()) >= 0) {
            if (!this._count.compareAndSet(count, count + 1)) continue;
            this._queue.add(obj);
            return true;
        }
        return false;
    }

    public List<T> close() {
        List<T> queue = this.ensureClosed();
        if (queue == null) {
            throw new IllegalStateException("Queue is already closed");
        }
        return queue;
    }

    public List<T> ensureClosed() {
        if (!this._closing.compareAndSet(false, true)) {
            return null;
        }
        boolean interrupted = false;
        int count = this._count.get();
        ArrayList<Object> members = new ArrayList<Object>(count);
        while (count >= 0) {
            if (this._count.compareAndSet(count, count - 1)) {
                if (count-- <= 0) continue;
                Object removed = null;
                while (removed == null) {
                    try {
                        removed = this._queue.take();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                members.add(removed);
                continue;
            }
            count = this._count.get();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return members;
    }

    public boolean isClosed() {
        return this._count.get() == -1;
    }
}

