/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.util;

import com.linkedin.r2.util.UncaughtExceptionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger _instanceNumber = new AtomicInteger();
    private final AtomicInteger _threadNumber = new AtomicInteger();
    private final String _namePrefix;
    private final UncaughtExceptionHandler _uncaughtExceptionHandler;

    public NamedThreadFactory(String name) {
        this(name, null);
    }

    public NamedThreadFactory(String name, UncaughtExceptionHandler uncaughtExceptionHandler) {
        this._namePrefix = name + "-" + _instanceNumber.incrementAndGet();
        this._uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this._namePrefix + "-" + this._threadNumber.incrementAndGet();
        Thread newThread = new Thread(runnable, name);
        if (this._uncaughtExceptionHandler != null) {
            newThread.setUncaughtExceptionHandler(this._uncaughtExceptionHandler);
        }
        return newThread;
    }
}

