/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import org.apache.gobblin.broker.ResourceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediatelyInvalidResourceEntry<T>
extends ResourceInstance<T> {
    private static final Logger log = LoggerFactory.getLogger(ImmediatelyInvalidResourceEntry.class);
    private boolean valid = true;

    public ImmediatelyInvalidResourceEntry(T resource) {
        super(resource);
    }

    @Override
    public synchronized T getResource() {
        this.valid = false;
        return super.getResource();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void onInvalidate() {
    }

    public synchronized T getResourceIfValid() {
        if (this.valid) {
            return this.getResource();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmediatelyInvalidResourceEntry)) {
            return false;
        }
        ImmediatelyInvalidResourceEntry other = (ImmediatelyInvalidResourceEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isValid() == other.isValid();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImmediatelyInvalidResourceEntry;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + (this.isValid() ? 79 : 97);
        return result;
    }
}

