/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class InstrumentedFileSystemUtils {
    public static URI replaceScheme(URI uri, String replace, String replacement) {
        if (replace != null && replace.equals(replacement)) {
            return uri;
        }
        try {
            if (replace != null && replace.equals(uri.getScheme())) {
                return new URI(replacement, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("Failed to replace scheme.");
        }
    }

    public static Path replaceScheme(Path path, String replace, String replacement) {
        return new Path(InstrumentedFileSystemUtils.replaceScheme(path.toUri(), replace, replacement));
    }

    public static Path[] replaceScheme(Path[] paths, String replace, String replacement) {
        if (replace != null && replace.equals(replacement)) {
            return paths;
        }
        Path[] output = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            output[i] = InstrumentedFileSystemUtils.replaceScheme(paths[i], replace, replacement);
        }
        return output;
    }

    public static FileStatus[] replaceScheme(FileStatus[] paths, String replace, String replacement) {
        if (replace != null && replace.equals(replacement)) {
            return paths;
        }
        FileStatus[] output = new FileStatus[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            output[i] = InstrumentedFileSystemUtils.replaceScheme(paths[i], replace, replacement);
        }
        return output;
    }

    public static FileStatus replaceScheme(FileStatus st, String replace, String replacement) {
        if (replace != null && replace.equals(replacement)) {
            return st;
        }
        try {
            return new FileStatus(st.getLen(), st.isDir(), (int)st.getReplication(), st.getBlockSize(), st.getModificationTime(), st.getAccessTime(), st.getPermission(), st.getOwner(), st.getGroup(), st.isSymlink() ? st.getSymlink() : null, InstrumentedFileSystemUtils.replaceScheme(st.getPath(), replace, replacement));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

