/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.codahale.metrics.Meter;
import com.google.common.base.Optional;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.gobblin.util.io.BatchedMeterDecorator;
import org.apache.gobblin.util.io.FilterStreamUnpacker;
import org.apache.gobblin.util.io.MeteredStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteredInputStream
extends FilterInputStream
implements MeteredStream {
    private static final Logger log = LoggerFactory.getLogger(MeteredInputStream.class);
    private BatchedMeterDecorator meter;

    public static Optional<MeteredInputStream> findWrappedMeteredInputStream(InputStream is) {
        if (is instanceof FilterInputStream) {
            try {
                Optional<MeteredInputStream> meteredInputStream = MeteredInputStream.findWrappedMeteredInputStream(FilterStreamUnpacker.unpackFilterInputStream((FilterInputStream)is));
                if (meteredInputStream.isPresent()) {
                    return meteredInputStream;
                }
            }
            catch (IllegalAccessException iae) {
                log.warn("Cannot unpack input stream due to SecurityManager.", (Throwable)iae);
            }
        }
        if (is instanceof MeteredInputStream) {
            return Optional.of((Object)((MeteredInputStream)is));
        }
        return Optional.absent();
    }

    private MeteredInputStream(InputStream in, Meter meter, int updateFrequency) {
        super(in);
        this.meter = new BatchedMeterDecorator(meter == null ? new Meter() : meter, updateFrequency > 0 ? updateFrequency : 1000);
    }

    @Override
    public int read() throws IOException {
        int bte = super.read();
        if (bte >= 0) {
            this.meter.mark();
        }
        return bte;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readBytes = super.read(b, off, len);
        this.meter.mark(readBytes);
        return readBytes;
    }

    @Override
    public Meter getBytesProcessedMeter() {
        return this.meter.getUnderlyingMeter();
    }

    public static MeteredInputStreamBuilder builder() {
        return new MeteredInputStreamBuilder();
    }

    public static class MeteredInputStreamBuilder {
        private InputStream in;
        private Meter meter;
        private int updateFrequency;

        MeteredInputStreamBuilder() {
        }

        public MeteredInputStreamBuilder in(InputStream in) {
            this.in = in;
            return this;
        }

        public MeteredInputStreamBuilder meter(Meter meter) {
            this.meter = meter;
            return this;
        }

        public MeteredInputStreamBuilder updateFrequency(int updateFrequency) {
            this.updateFrequency = updateFrequency;
            return this;
        }

        public MeteredInputStream build() {
            return new MeteredInputStream(this.in, this.meter, this.updateFrequency);
        }

        public String toString() {
            return "MeteredInputStream.MeteredInputStreamBuilder(in=" + this.in + ", meter=" + this.meter + ", updateFrequency=" + this.updateFrequency + ")";
        }
    }
}

